/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.util.Log;
import com.facebook.LoggingBehavior;
import com.facebook.Settings;
import com.facebook.internal.Validate;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    public static final String LOG_TAG_BASE = "FacebookSDK.";
    private static final HashMap<String, String> stringsToReplace = new HashMap();
    private final LoggingBehavior behavior;
    private final String tag;
    private StringBuilder contents;
    private int priority = 3;

    public static synchronized void registerStringToReplace(String original, String replace) {
        stringsToReplace.put(original, replace);
    }

    public static synchronized void registerAccessToken(String accessToken) {
        if (!Settings.isLoggingBehaviorEnabled(LoggingBehavior.INCLUDE_ACCESS_TOKENS)) {
            Logger.registerStringToReplace(accessToken, "ACCESS_TOKEN_REMOVED");
        }
    }

    public static void log(LoggingBehavior behavior, String tag, String string2) {
        Logger.log(behavior, 3, tag, string2);
    }

    public static void log(LoggingBehavior behavior, String tag, String format, Object ... args) {
        if (Settings.isLoggingBehaviorEnabled(behavior)) {
            String string2 = String.format(format, args);
            Logger.log(behavior, 3, tag, string2);
        }
    }

    public static void log(LoggingBehavior behavior, int priority, String tag, String string2) {
        if (Settings.isLoggingBehaviorEnabled(behavior)) {
            string2 = Logger.replaceStrings(string2);
            if (!tag.startsWith(LOG_TAG_BASE)) {
                tag = LOG_TAG_BASE + tag;
            }
            Log.println((int)priority, (String)tag, (String)string2);
            if (behavior == LoggingBehavior.DEVELOPER_ERRORS) {
                new Exception().printStackTrace();
            }
        }
    }

    private static synchronized String replaceStrings(String string2) {
        for (Map.Entry<String, String> entry : stringsToReplace.entrySet()) {
            string2 = string2.replace(entry.getKey(), entry.getValue());
        }
        return string2;
    }

    public Logger(LoggingBehavior behavior, String tag) {
        Validate.notNullOrEmpty(tag, "tag");
        this.behavior = behavior;
        this.tag = LOG_TAG_BASE + tag;
        this.contents = new StringBuilder();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int value) {
        Validate.oneOf(value, "value", 7, 3, 6, 4, 2, 5);
        this.priority = value;
    }

    public String getContents() {
        return Logger.replaceStrings(this.contents.toString());
    }

    public void log() {
        this.logString(this.contents.toString());
        this.contents = new StringBuilder();
    }

    public void logString(String string2) {
        Logger.log(this.behavior, this.priority, this.tag, string2);
    }

    public void append(StringBuilder stringBuilder) {
        if (this.shouldLog()) {
            this.contents.append((CharSequence)stringBuilder);
        }
    }

    public void append(String string2) {
        if (this.shouldLog()) {
            this.contents.append(string2);
        }
    }

    public void append(String format, Object ... args) {
        if (this.shouldLog()) {
            this.contents.append(String.format(format, args));
        }
    }

    public void appendKeyValue(String key, Object value) {
        this.append("  %s:\t%s\n", key, value);
    }

    private boolean shouldLog() {
        return Settings.isLoggingBehaviorEnabled(this.behavior);
    }
}

