/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.util.Pair;
import com.facebook.NativeAppCallAttachmentStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.UUID;

public class NativeAppCallContentProvider
extends ContentProvider {
    private static final String TAG = NativeAppCallContentProvider.class.getName();
    private static final String ATTACHMENT_URL_BASE = "content://com.facebook.app.NativeAppCallContentProvider";
    private final AttachmentDataSource dataSource;

    public NativeAppCallContentProvider() {
        this(new NativeAppCallAttachmentStore());
    }

    NativeAppCallContentProvider(AttachmentDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static String getAttachmentUrl(String applicationId, UUID callId, String attachmentName) {
        return String.format("%s%s/%s/%s", ATTACHMENT_URL_BASE, applicationId, callId.toString(), attachmentName);
    }

    public boolean onCreate() {
        return true;
    }

    public Cursor query(Uri uri, String[] strings, String s, String[] strings2, String s2) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        return null;
    }

    public int delete(Uri uri, String s, String[] strings) {
        return 0;
    }

    public int update(Uri uri, ContentValues contentValues, String s, String[] strings) {
        return 0;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        Pair<UUID, String> callIdAndAttachmentName = this.parseCallIdAndAttachmentName(uri);
        if (callIdAndAttachmentName == null) {
            throw new FileNotFoundException();
        }
        try {
            File file = this.dataSource.openAttachment((UUID)callIdAndAttachmentName.first, (String)callIdAndAttachmentName.second);
            return ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException exception) {
            Log.e((String)TAG, (String)("Got unexpected exception:" + exception));
            throw exception;
        }
    }

    Pair<UUID, String> parseCallIdAndAttachmentName(Uri uri) {
        try {
            String callIdAndAttachmentName = uri.getPath().substring(1);
            String[] parts = callIdAndAttachmentName.split("/");
            String callIdString = parts[0];
            String attachmentName = parts[1];
            UUID callId = UUID.fromString(callIdString);
            return new Pair((Object)callId, (Object)attachmentName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static interface AttachmentDataSource {
        public File openAttachment(UUID var1, String var2) throws FileNotFoundException;
    }
}

