/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Aggregator;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.sql.ResultSet;
import java.sql.SQLException;

final class ResultSetCheckInOrder
implements Check<ResultSet> {
    private final Iterable<Check<? super ResultSet>> checks;
    private final boolean full;
    private final boolean exact;

    ResultSetCheckInOrder(Iterable<Check<? super ResultSet>> checks, boolean full, boolean exact) {
        this.checks = checks;
        this.full = full;
        this.exact = exact;
    }

    private boolean match(Check<? super ResultSet> check, ResultSet data, Aggregator resultBuilder, ResultFactory factory) throws SQLException {
        while (data.next()) {
            if (resultBuilder.add(check.evaluate(data, factory)).passed()) {
                return true;
            }
            if (!this.exact) continue;
            return false;
        }
        return false;
    }

    @Override
    public Result evaluate(ResultSet data, ResultFactory factory) {
        if (data == null) {
            return factory.expectation(this, false);
        }
        Aggregator resultBuilder = factory.aggregator(this);
        try {
            for (Check<? super ResultSet> check : this.checks) {
                if (this.match(check, data, resultBuilder, factory)) continue;
                return resultBuilder.build(check + " not matched by any item", false);
            }
            if (this.full && this.exact && !data.next()) {
                return resultBuilder.build("Extra record found", false);
            }
        }
        catch (SQLException e) {
            return resultBuilder.build(e, false);
        }
        return resultBuilder.build("Items matched checks", true);
    }

    public String toString() {
        return "Items matching " + this.checks;
    }
}

