/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.UncheckedInterruptedException;
import java.time.Duration;
import java.util.Iterator;

public final class Repeater<T>
implements Iterable<T> {
    private final T item;
    private final int max;
    private final int increment;
    private final long delayInMillis;

    private Repeater(T item, int max, int increment, long delayInMillis) {
        this.item = item;
        this.max = max;
        this.increment = increment;
        this.delayInMillis = delayInMillis;
    }

    public static <T> Repeater<T> repeat(T item, int max, long delayInMillis) {
        return new Repeater<T>(item, max, 1, delayInMillis);
    }

    public static <T> Repeater<T> repeatForever(T item, long delayInMillis) {
        return new Repeater<T>(item, 1, 0, delayInMillis);
    }

    public static <T> Repeater<T> repeatForever(T item, Duration delay) {
        return new Repeater<T>(item, 1, 0, delay.toMillis());
    }

    public static <T> Repeater<T> repeat(T item, int max, Duration delay) {
        return Repeater.repeat(item, max, delay.toMillis());
    }

    public static <T> Repeater<T> repeat(T item, int max) {
        return Repeater.repeat(item, max, 1000L);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int attempt = 0;

            @Override
            public boolean hasNext() {
                return this.attempt < Repeater.this.max;
            }

            @Override
            public T next() {
                if (this.attempt > 0 && Repeater.this.delayInMillis > 0L) {
                    try {
                        Thread.sleep(Repeater.this.delayInMillis);
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedInterruptedException((Object)("Delay before repeating " + Repeater.this.item + " interrupted"), (Throwable)e);
                    }
                }
                this.attempt += Repeater.this.increment;
                return Repeater.this.item;
            }
        };
    }
}

