/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.CheckBuilder;
import fluent.validation.CollectionChecks;
import fluent.validation.ComparisonChecks;
import fluent.validation.DateTimeChecks;
import fluent.validation.Items;
import fluent.validation.NumericChecks;
import fluent.validation.Predicate;
import fluent.validation.StringChecks;
import fluent.validation.ThrowingCheck;
import fluent.validation.Transformation;
import fluent.validation.TransformationBuilder;
import fluent.validation.Value;
import fluent.validation.XmlChecks;
import fluent.validation.dsl.LocalDateCheck;
import fluent.validation.dsl.LocalDateTimeCheck;
import fluent.validation.dsl.LocalTimeCheck;
import fluent.validation.dsl.ZonedDateTimeCheck;
import fluent.validation.result.ResultFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public final class Checks {
    private Checks() {
    }

    public static Check<Double> closeTo(double expectedValue, double precision) {
        return NumericChecks.closeTo(expectedValue, precision);
    }

    public static Check<Float> closeTo(float expectedValue, float precision) {
        return NumericChecks.closeTo(expectedValue, precision);
    }

    public static Check<BigDecimal> closeTo(BigDecimal expectedValue, BigDecimal precision) {
        return NumericChecks.closeTo(expectedValue, precision);
    }

    public static Check<Double> equalTo(Double expectedValue) {
        return NumericChecks.equalTo(expectedValue);
    }

    public static Check<Float> equalTo(Float expectedValue) {
        return NumericChecks.equalTo(expectedValue);
    }

    public static Check<BigDecimal> equalTo(BigDecimal expectedValue) {
        return NumericChecks.equalTo(expectedValue);
    }

    public static Check<String> parseDouble(Check<? super Double> check) {
        return NumericChecks.parseDouble(check);
    }

    public static Check<String> parseDouble(Double expectedValue) {
        return NumericChecks.parseDouble(expectedValue);
    }

    public static Check<String> parseDouble(double expectedValue) {
        return NumericChecks.parseDouble(expectedValue);
    }

    public static Check<String> parseFloat(Check<? super Float> check) {
        return NumericChecks.parseFloat(check);
    }

    public static Check<String> parseFloat(Float expectedValue) {
        return NumericChecks.parseFloat(expectedValue);
    }

    public static Check<String> parseFloat(float expectedValue) {
        return NumericChecks.parseFloat(expectedValue);
    }

    public static Check<String> parseInt(Check<? super Integer> check) {
        return NumericChecks.parseInt(check);
    }

    public static Check<String> parseInt(Integer expectedValue) {
        return NumericChecks.parseInt(expectedValue);
    }

    public static Check<String> parseInt(int expectedValue) {
        return NumericChecks.parseInt(expectedValue);
    }

    public static Check<String> parseLong(Check<? super Long> check) {
        return NumericChecks.parseLong(check);
    }

    public static Check<String> parseLong(Long expectedValue) {
        return NumericChecks.parseLong(expectedValue);
    }

    public static Check<String> parseLong(long expectedValue) {
        return NumericChecks.parseLong(expectedValue);
    }

    public static Check<String> parseShort(Check<? super Short> check) {
        return NumericChecks.parseShort(check);
    }

    public static Check<String> parseShort(Short expectedValue) {
        return NumericChecks.parseShort(expectedValue);
    }

    public static Check<String> parseShort(short expectedValue) {
        return NumericChecks.parseShort(expectedValue);
    }

    public static Check<String> parseBigDecimal(Check<? super BigDecimal> check) {
        return NumericChecks.parseBigDecimal(check);
    }

    public static Check<String> parseBigInt(Check<? super BigInteger> check) {
        return NumericChecks.parseBigInt(check);
    }

    public static Check<String> parseByte(Check<? super Byte> check) {
        return NumericChecks.parseByte(check);
    }

    public static Check<String> parseByte(Byte expectedValue) {
        return NumericChecks.parseByte(expectedValue);
    }

    public static Check<String> parseByte(byte expectedValue) {
        return NumericChecks.parseByte(expectedValue);
    }

    public static Check<String> parseBoolean(Check<? super Boolean> check) {
        return NumericChecks.parseBoolean(check);
    }

    public static Check<String> parseBoolean(Boolean expectedValue) {
        return NumericChecks.parseBoolean(expectedValue);
    }

    public static <D> Check<D> nullableCheck(Predicate<D> predicate, String expectationDescription) {
        return BasicChecks.nullableCheck(predicate, expectationDescription);
    }

    public static <D> Check<D> require(Check<? super D> requirement, Check<? super D> check) {
        return BasicChecks.require(requirement, check);
    }

    public static <D> Check<D> requireNotNull(Check<D> check) {
        return BasicChecks.requireNotNull(check);
    }

    public static <D> Check<D> check(Predicate<D> predicate, String expectationDescription) {
        return BasicChecks.check(predicate, expectationDescription);
    }

    public static <D> Check<D> sameInstance(D expectedInstance) {
        return BasicChecks.sameInstance(expectedInstance);
    }

    public static <D> Check<D> equalTo(D expectedValue) {
        return BasicChecks.equalTo(expectedValue);
    }

    public static <D> Check<D> is(D expectedValue) {
        return BasicChecks.is(expectedValue);
    }

    public static Check<Object> isNull() {
        return BasicChecks.isNull();
    }

    public static Check<Object> isNotNull() {
        return BasicChecks.isNotNull();
    }

    public static Check<Object> anything() {
        return BasicChecks.anything();
    }

    public static Check<Object> instanceOf(Class<?> expectedClass) {
        return BasicChecks.instanceOf(expectedClass);
    }

    public static Check<Object> isA(Class<?> expectedClass) {
        return BasicChecks.isA(expectedClass);
    }

    public static Check<Object> isAn(Class<?> expectedClass) {
        return BasicChecks.isAn(expectedClass);
    }

    public static Check<Object> a(Class<?> expectedClass) {
        return BasicChecks.a(expectedClass);
    }

    public static Check<Object> an(Class<?> expectedClass) {
        return BasicChecks.an(expectedClass);
    }

    public static Check<Object> sameClass(Class<?> expectedClass) {
        return BasicChecks.sameClass(expectedClass);
    }

    public static <D> Check<D> not(Check<D> positiveCheck) {
        return BasicChecks.not(positiveCheck);
    }

    public static <D> Check<D> not(D positiveValue) {
        return BasicChecks.not(positiveValue);
    }

    public static <D> Check<D> oneOf(Collection<D> alternatives) {
        return BasicChecks.oneOf(alternatives);
    }

    @SafeVarargs
    public static <D> Check<D> oneOf(D ... alternatives) {
        return BasicChecks.oneOf(alternatives);
    }

    public static <D> Check<D> anyOf(Iterable<Check<? super D>> operands) {
        return BasicChecks.anyOf(operands);
    }

    @SafeVarargs
    public static <D> Check<D> anyOf(Check<? super D> ... operands) {
        return BasicChecks.anyOf(operands);
    }

    public static <D> Check<D> allOf(Iterable<Check<? super D>> operands) {
        return BasicChecks.allOf(operands);
    }

    @SafeVarargs
    public static <D> Check<D> allOf(Check<? super D> ... operands) {
        return BasicChecks.allOf(operands);
    }

    public static <D, V> Check<D> transform(Transformation<? super D, V> transformation, Check<? super V> check) {
        return BasicChecks.transform(transformation, check);
    }

    public static <D, V> Check<D> compose(String name, Transformation<? super D, V> transformation, Check<? super V> check) {
        return BasicChecks.compose(name, transformation, check);
    }

    public static <D, V> Check<D> compose(Transformation<? super D, V> transformation, Check<? super V> check) {
        return BasicChecks.compose(transformation, check);
    }

    public static <D, V> TransformationBuilder<V, Check<D>> has(String name, Transformation<? super D, V> transformation) {
        return BasicChecks.has(name, transformation);
    }

    public static <D, V> TransformationBuilder<V, Check<D>> has(Transformation<? super D, V> transformation) {
        return BasicChecks.has(transformation);
    }

    public static <D, V> TransformationBuilder<V, Check<D>> nullableHas(String name, Transformation<? super D, V> transformation) {
        return BasicChecks.nullableHas(name, transformation);
    }

    public static <D, V> TransformationBuilder<V, Check<D>> nullableHas(Transformation<? super D, V> transformation) {
        return BasicChecks.nullableHas(transformation);
    }

    public static <V> TransformationBuilder<V, Check<V>> as(Class<V> type) {
        return BasicChecks.as(type);
    }

    public static Check<Throwable> message(Check<? super String> check) {
        return BasicChecks.message(check);
    }

    public static ThrowingCheck throwing(Check<? super Throwable> check) {
        return BasicChecks.throwing(check);
    }

    public static ThrowingCheck throwing(Class<? extends Throwable> expectedType) {
        return BasicChecks.throwing(expectedType);
    }

    public static <D> Check<D> createBuilder() {
        return BasicChecks.createBuilder();
    }

    public static <D> Check<D> createBuilderWith(Check<D> check) {
        return BasicChecks.createBuilderWith(check);
    }

    public static <D> Check<D> which(Check<D> check) {
        return BasicChecks.which(check);
    }

    public static <D> CheckBuilder<D> dsl() {
        return BasicChecks.dsl();
    }

    public static <D> Value<D> value() {
        return BasicChecks.value();
    }

    public static <D> Check<D> softCheck(Check<D> check) {
        return BasicChecks.softCheck(check);
    }

    public static <D> Check<D> customResultFactory(Check<D> check, ResultFactory customResultFactory) {
        return BasicChecks.customResultFactory(check, customResultFactory);
    }

    public static Check<LocalDateTime> date(Check<? super LocalDate> dateCheck) {
        return DateTimeChecks.date(dateCheck);
    }

    public static Check<LocalDateTime> time(Check<? super LocalTime> dateCheck) {
        return DateTimeChecks.time(dateCheck);
    }

    public static Check<LocalDateTime> zoned(Check<? super ZonedDateTime> zonedDateTimeCheck, ZoneId zoneId) {
        return DateTimeChecks.zoned(zonedDateTimeCheck, zoneId);
    }

    public static Check<LocalDateTime> zoned(Check<? super ZonedDateTime> zonedDateTimeCheck) {
        return DateTimeChecks.zoned(zonedDateTimeCheck);
    }

    public static LocalDateTimeCheck localDateTimeWith() {
        return DateTimeChecks.localDateTimeWith();
    }

    public static LocalDateCheck localDateWith() {
        return DateTimeChecks.localDateWith();
    }

    public static LocalTimeCheck localTimeWith() {
        return DateTimeChecks.localTimeWith();
    }

    public static ZonedDateTimeCheck zonedDateTimeWith() {
        return DateTimeChecks.zonedDateTimeWith();
    }

    public static Check<String> parseLocalDateTime(Check<? super LocalDateTime> check) {
        return DateTimeChecks.parseLocalDateTime(check);
    }

    public static Check<String> parseLocalDateTime(String format, Check<? super LocalDateTime> check) {
        return DateTimeChecks.parseLocalDateTime(format, check);
    }

    public static Check<String> parseLocalDateTime(DateTimeFormatter format, Check<? super LocalDateTime> check) {
        return DateTimeChecks.parseLocalDateTime(format, check);
    }

    public static Check<String> parseZonedDateTime(Check<? super ZonedDateTime> check) {
        return DateTimeChecks.parseZonedDateTime(check);
    }

    public static Check<String> parseZonedDateTime(String format, Check<? super ZonedDateTime> check) {
        return DateTimeChecks.parseZonedDateTime(format, check);
    }

    public static Check<String> parseZonedDateTime(DateTimeFormatter format, Check<? super ZonedDateTime> check) {
        return DateTimeChecks.parseZonedDateTime(format, check);
    }

    public static <D> Check<Iterable<D>> exists(String elementName, Check<? super D> check) {
        return CollectionChecks.exists(elementName, check);
    }

    public static <D> Check<Iterable<D>> every(String elementName, Check<? super D> check) {
        return CollectionChecks.every(elementName, check);
    }

    public static <D> Check<D> repeatMax(Check<D> attemptCheck, int max) {
        return CollectionChecks.repeatMax(attemptCheck, max);
    }

    public static <D> Check<D> repeatMax(Check<D> itemCheck, int max, Duration delay) {
        return CollectionChecks.repeatMax(itemCheck, max, delay);
    }

    public static <T> Check<Iterator<T>> startsWith(String elementName, Items<T> prefix) {
        return CollectionChecks.startsWith(elementName, prefix);
    }

    public static <T> Check<Iterator<T>> contains(String elementName, Items<T> elementChecks) {
        return CollectionChecks.contains(elementName, elementChecks);
    }

    public static <T> Check<Iterator<T>> equalTo(String elementName, Items<T> elementChecks) {
        return CollectionChecks.equalTo(elementName, elementChecks);
    }

    public static <T> Check<Iterator<T>> startsWith(Items<T> prefix) {
        return CollectionChecks.startsWith(prefix);
    }

    public static <T> Check<Iterator<T>> contains(Items<T> elementChecks) {
        return CollectionChecks.contains(elementChecks);
    }

    public static <T> Check<Iterator<T>> equalTo(Items<T> elementChecks) {
        return CollectionChecks.equalTo(elementChecks);
    }

    public static <T> Check<Iterator<T>> startsInAnyOrderWith(String elementName, Items<T> prefixElementChecks) {
        return CollectionChecks.startsInAnyOrderWith(elementName, prefixElementChecks);
    }

    public static <T> Check<Iterator<T>> containsInAnyOrder(String elementName, Items<T> elementChecks) {
        return CollectionChecks.containsInAnyOrder(elementName, elementChecks);
    }

    public static <T> Check<Iterator<T>> containsInAnyOrderOnly(String elementName, Items<T> elementChecks) {
        return CollectionChecks.containsInAnyOrderOnly(elementName, elementChecks);
    }

    public static <T> Check<Iterator<T>> equalInAnyOrderTo(String elementName, Items<T> elementChecks) {
        return CollectionChecks.equalInAnyOrderTo(elementName, elementChecks);
    }

    public static <T> Check<Iterator<T>> startsInAnyOrderWith(Items<T> prefixElementChecks) {
        return CollectionChecks.startsInAnyOrderWith(prefixElementChecks);
    }

    public static <T> Check<Iterator<T>> containsInAnyOrder(Items<T> elementChecks) {
        return CollectionChecks.containsInAnyOrder(elementChecks);
    }

    public static <T> Check<Iterator<T>> containsInAnyOrderOnly(Items<T> elementChecks) {
        return CollectionChecks.containsInAnyOrderOnly(elementChecks);
    }

    public static <T> Check<Iterator<T>> equalInAnyOrderTo(Items<T> elementChecks) {
        return CollectionChecks.equalInAnyOrderTo(elementChecks);
    }

    public static <T> Check<Iterable<T>> collection(Check<Iterator<T>> check) {
        return CollectionChecks.collection(check);
    }

    public static <T> Check<T[]> array(Check<Iterator<T>> check) {
        return CollectionChecks.array(check);
    }

    public static <T> Check<Queue<T>> queue(Check<Iterator<T>> check) {
        return CollectionChecks.queue(check);
    }

    public static <T> Check<BlockingQueue<T>> blockingQueue(Check<Iterator<T>> check, Duration timeout) {
        return CollectionChecks.blockingQueue(check, timeout);
    }

    public static <D> Check<Collection<D>> emptyCollection() {
        return CollectionChecks.emptyCollection();
    }

    public static <D> Check<Collection<D>> subsetOf(Collection<D> superSet) {
        return CollectionChecks.subsetOf(superSet);
    }

    @SafeVarargs
    public static <D> Check<Collection<D>> subsetOf(D ... superSet) {
        return CollectionChecks.subsetOf(superSet);
    }

    public static <D> Check<Collection<D>> hasSize(int size) {
        return CollectionChecks.hasSize(size);
    }

    public static <D> Check<Collection<D>> containsAll(Collection<D> items) {
        return CollectionChecks.containsAll(items);
    }

    @SafeVarargs
    public static <D> Check<Collection<D>> containsAll(D ... items) {
        return CollectionChecks.containsAll(items);
    }

    public static <K, V> Check<Map<K, V>> mapHas(K key, Check<? super V> check) {
        return CollectionChecks.mapHas(key, check);
    }

    public static <D> Check<D[]> emptyArray() {
        return CollectionChecks.emptyArray();
    }

    public static <D> Check<D[]> emptyArrayOrNull() {
        return CollectionChecks.emptyArrayOrNull();
    }

    public static <D> Check<D> lessThan(D operand, Comparator<D> comparator) {
        return ComparisonChecks.lessThan(operand, comparator);
    }

    public static <D> Check<D> moreThan(D operand, Comparator<D> comparator) {
        return ComparisonChecks.moreThan(operand, comparator);
    }

    public static <D> Check<D> equalOrLessThan(D operand, Comparator<D> comparator) {
        return ComparisonChecks.equalOrLessThan(operand, comparator);
    }

    public static <D> Check<D> equalOrMoreThan(D operand, Comparator<D> comparator) {
        return ComparisonChecks.equalOrMoreThan(operand, comparator);
    }

    public static <D extends Comparable<D>> Check<D> lessThan(D operand) {
        return ComparisonChecks.lessThan(operand);
    }

    public static <D extends Comparable<D>> Check<D> moreThan(D operand) {
        return ComparisonChecks.moreThan(operand);
    }

    public static <D extends Comparable<D>> Check<D> equalOrLessThan(D operand) {
        return ComparisonChecks.equalOrLessThan(operand);
    }

    public static <D extends Comparable<D>> Check<D> equalOrMoreThan(D operand) {
        return ComparisonChecks.equalOrMoreThan(operand);
    }

    public static <D extends Comparable<D>> Check<D> between(D left, D right) {
        return ComparisonChecks.between(left, right);
    }

    public static <D> Check<D> between(D left, D right, Comparator<D> comparator) {
        return ComparisonChecks.between(left, right, comparator);
    }

    public static <D> Check<D> betweenInclusive(D left, D right, Comparator<D> comparator) {
        return ComparisonChecks.betweenInclusive(left, right, comparator);
    }

    public static <D extends Comparable<D>> Check<D> betweenInclusive(D left, D right) {
        return ComparisonChecks.betweenInclusive(left, right);
    }

    public static Check<String> equalCaseInsensitiveTo(String expectedValue) {
        return StringChecks.equalCaseInsensitiveTo(expectedValue);
    }

    public static Check<String> emptyString() {
        return StringChecks.emptyString();
    }

    public static Check<String> trim(Check<? super String> check) {
        return StringChecks.trim(check);
    }

    public static Check<String> startsWith(String prefix) {
        return StringChecks.startsWith(prefix);
    }

    public static Check<String> startsCaseInsensitiveWith(String prefix) {
        return StringChecks.startsCaseInsensitiveWith(prefix);
    }

    public static Check<String> endsWith(String suffix) {
        return StringChecks.endsWith(suffix);
    }

    public static Check<String> endsCaseInsensitiveWith(String suffix) {
        return StringChecks.endsCaseInsensitiveWith(suffix);
    }

    public static Check<String> contains(String substring) {
        return StringChecks.contains(substring);
    }

    public static Check<String> containsCaseInsensitive(String substring) {
        return StringChecks.containsCaseInsensitive(substring);
    }

    public static Check<String> matches(Pattern pattern) {
        return StringChecks.matches(pattern);
    }

    public static Check<String> matchesPattern(String pattern) {
        return StringChecks.matchesPattern(pattern);
    }

    public static Check<Object> matchesXPath(String xPath) {
        return XmlChecks.matchesXPath(xPath);
    }

    public static TransformationBuilder<Object, Check<Object>> hasNode(String xPath, QName type) {
        return XmlChecks.hasNode(xPath, type);
    }

    public static TransformationBuilder<Object, Check<Object>> hasNode(String xPath) {
        return XmlChecks.hasNode(xPath);
    }

    public static TransformationBuilder<Object, Check<String>> hasTextContent(String xPath) {
        return XmlChecks.hasTextContent(xPath);
    }

    public static Check<String> parseXml(Check<? super Document> check) {
        return XmlChecks.parseXml(check);
    }

    public static Check<String> loadXml(Check<? super Document> check) {
        return XmlChecks.loadXml(check);
    }
}

