/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.result;

import fluent.validation.Check;
import fluent.validation.result.ActualValueInResult;
import fluent.validation.result.Aggregator;
import fluent.validation.result.DefaultResultFactory;
import fluent.validation.result.Result;
import fluent.validation.result.TableAggregator;
import fluent.validation.result.TableInResult;
import java.util.ArrayList;
import java.util.List;

public interface ResultFactory {
    public static final ResultFactory DEFAULT = new DefaultResultFactory();

    public Result actual(Object var1, Result var2);

    public Result expectation(Object var1, boolean var2);

    public Result named(Object var1, Result var2, boolean var3);

    public Result soft(Result var1);

    public Result aggregation(Object var1, String var2, List<Result> var3, boolean var4);

    default public <D> TableAggregator<D> table(Object prefix, final ArrayList<Check<? super D>> checks) {
        return new TableAggregator<D>(){
            private final List<Object> values = new ArrayList<Object>();
            private final List<TableInResult.Cell> results = new ArrayList<TableInResult.Cell>();

            @Override
            public Result build(String description, int column, boolean value) {
                return new ActualValueInResult(description, new TableInResult(description, checks, this.values, this.results, value));
            }

            @Override
            public Result build(String description, boolean value) {
                return new ActualValueInResult(description, new TableInResult(description, checks, this.values, this.results, value));
            }

            @Override
            public Result cell(int row, int column, Result result) {
                this.results.add(new TableInResult.Cell(row, column, result));
                return result;
            }

            @Override
            public int column(Object item) {
                this.values.add(item);
                return this.values.size() - 1;
            }
        };
    }

    public Result error(Throwable var1);

    public Result invert(Result var1);

    default public Aggregator aggregator(final Object prefix, final String glue) {
        return new Aggregator(){
            private final List<Result> items = new ArrayList<Result>();

            @Override
            public Result add(Result itemResult) {
                this.items.add(itemResult);
                return itemResult;
            }

            @Override
            public Result build(Object actualValueDescription, boolean result) {
                return ResultFactory.this.actual(actualValueDescription, ResultFactory.this.aggregation(prefix, glue, this.items, result));
            }
        };
    }

    default public Aggregator aggregator(Object prefix) {
        return this.aggregator(prefix, ", ");
    }
}

