/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.util.ArrayList;
import java.util.List;

public class Value<D> {
    private final List<D> values = new ArrayList<D>();

    public final Check<D> storeWhen(final Check<? super D> condition) {
        return new Check<D>(){

            @Override
            protected Result evaluate(D data, ResultFactory factory) {
                Result result = condition.evaluate(data, factory);
                if (result.passed()) {
                    Value.this.values.add(data);
                }
                return result;
            }

            @Override
            public String toString() {
                return "Store value when " + condition;
            }
        };
    }

    public final D get() {
        if (this.values.isEmpty()) {
            throw new IllegalStateException("Value was not stored yet. Use method storeWhen(check) first or check, if evaluation of that method wasn't missed due to fast pass / fail composition or requirement not met in required check.");
        }
        return this.values.get(this.values.size() - 1);
    }

    public final List<D> getAll() {
        if (this.values.isEmpty()) {
            throw new IllegalStateException("Value was not stored yet. Use method storeWhen(check) first or check, if evaluation of that method wasn't missed due to fast pass / fail composition or requirement not met in required check.");
        }
        return new ArrayList<D>(this.values);
    }
}

