/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.MapItemCheck;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.util.Map;

public class MapCheckBuilder<K, V>
extends Check<Map<K, V>> {
    private final Check<? super Map<K, V>> check;

    public MapCheckBuilder(Check<? super Map<K, V>> check) {
        this.check = check;
    }

    public MapCheckBuilder() {
        this(BasicChecks.anything());
    }

    @Override
    protected Result evaluate(Map<K, V> data, ResultFactory factory) {
        return this.check.evaluate(data, factory);
    }

    @Override
    public String toString() {
        return this.check.toString();
    }

    public MapCheckBuilder<K, V> with(K key, Check<? super V> check) {
        return new MapCheckBuilder<K, V>(this.check.and(new MapItemCheck<K, V>(key, check)));
    }

    public MapCheckBuilder<K, V> with(K key, V expectedValue) {
        return this.with(key, (V)BasicChecks.equalTo(expectedValue));
    }
}

