/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.api.End;
import fluent.validation.And;
import fluent.validation.Or;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import fluent.validation.result.ResultVisitor;

public abstract class Check<T> {
    protected abstract Result evaluate(T var1, ResultFactory var2);

    public abstract String toString();

    public <U extends T> Check<U> and(Check<? super U> operand) {
        return new And<U>(this, operand);
    }

    public <U extends T> Check<U> or(Check<? super U> operand) {
        return new Or<U>(this, operand);
    }

    @End(message="Check is not used. Pass it either to Assert.that(), Check.that() or Check.evaluate().")
    public static <T> boolean that(T data, Check<? super T> check) {
        return Check.evaluate(data, check).passed();
    }

    public static <T> boolean that(T data, Check<? super T> check, ResultVisitor visitor) {
        Result result = Check.evaluate(data, check);
        visitor.visit(result);
        return result.passed();
    }

    public static <T> Result evaluate(T data, Check<? super T> check) {
        return ResultFactory.DEFAULT.actual(data, check.evaluate(data, ResultFactory.DEFAULT));
    }
}

