/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.CheckBuilder;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class XmlChecks {
    private static final XPath xPath = XPathFactory.newInstance().newXPath();

    private static XPathExpression compile(String xPath) {
        try {
            return XmlChecks.xPath.compile(xPath);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Check<Object> matchesXPath(String xPath) {
        XPathExpression xPathExpression = XmlChecks.compile(xPath);
        return BasicChecks.check(xml -> Boolean.TRUE.equals(xPathExpression.evaluate(xml, XPathConstants.BOOLEAN)), xPath);
    }

    public static CheckBuilder<Object, Check<Object>> hasNode(String xPath, QName type) {
        XPathExpression xPathExpression = XmlChecks.compile(xPath);
        return BasicChecks.has(xPath, xml -> xPathExpression.evaluate(xml, type));
    }

    public static CheckBuilder<Object, Check<Object>> hasNode(String xPath) {
        return XmlChecks.hasNode(xPath, XPathConstants.NODE);
    }

    public static CheckBuilder<Object, Check<String>> hasXPath(String xPath) {
        XPathExpression xPathExpression = XmlChecks.compile(xPath);
        return BasicChecks.has(xPath, xPathExpression::evaluate);
    }
}

