/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.Transformation;
import fluent.validation.UncheckedInterruptedException;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;

final class TransformedCheck<D, V>
extends Check<D> {
    private final Transformation<? super D, V> transformation;
    private final Check<? super V> check;

    TransformedCheck(Transformation<? super D, V> transformation, Check<? super V> check) {
        this.transformation = transformation;
        this.check = check;
    }

    @Override
    protected Result evaluate(D data, ResultFactory factory) {
        V value;
        try {
            value = this.transformation.apply(data);
        }
        catch (UncheckedInterruptedException interrupted) {
            throw interrupted;
        }
        catch (Error | Exception unchecked) {
            return factory.error(unchecked);
        }
        return factory.actual(value, this.check.evaluate(value, factory));
    }

    @Override
    public String toString() {
        return "" + this.check;
    }
}

