/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import java.util.Comparator;

public final class ComparisonChecks {
    private ComparisonChecks() {
    }

    public static <D> Check<D> lessThan(D operand, Comparator<D> comparator) {
        return BasicChecks.check(data -> comparator.compare(data, operand) < 0, "< " + operand);
    }

    public static <D> Check<D> moreThan(D operand, Comparator<D> comparator) {
        return BasicChecks.check(data -> comparator.compare(data, operand) > 0, "> " + operand);
    }

    public static <D> Check<D> equalOrLessThan(D operand, Comparator<D> comparator) {
        return BasicChecks.check(data -> comparator.compare(data, operand) <= 0, "<= " + operand);
    }

    public static <D> Check<D> equalOrMoreThan(D operand, Comparator<D> comparator) {
        return BasicChecks.check(data -> comparator.compare(data, operand) >= 0, ">= " + operand);
    }

    public static <D extends Comparable<D>> Check<D> lessThan(D operand) {
        return ComparisonChecks.lessThan(operand, Comparable::compareTo);
    }

    public static <D extends Comparable<D>> Check<D> moreThan(D operand) {
        return ComparisonChecks.moreThan(operand, Comparable::compareTo);
    }

    public static <D extends Comparable<D>> Check<D> equalOrLessThan(D operand) {
        return ComparisonChecks.equalOrLessThan(operand, Comparable::compareTo);
    }

    public static <D extends Comparable<D>> Check<D> equalOrMoreThan(D operand) {
        return ComparisonChecks.equalOrMoreThan(operand, Comparable::compareTo);
    }

    public static <D extends Comparable<D>> Check<D> between(D left, D right) {
        return ComparisonChecks.between(left, right, Comparable::compareTo);
    }

    public static <D> Check<D> between(D left, D right, Comparator<D> comparator) {
        if (comparator.compare(left, right) > 0) {
            comparator = comparator.reversed();
        }
        return ComparisonChecks.moreThan(left, comparator).and(ComparisonChecks.lessThan(right, comparator));
    }

    public static <D> Check<D> betweenInclusive(D left, D right, Comparator<D> comparator) {
        if (comparator.compare(left, right) > 0) {
            comparator = comparator.reversed();
        }
        return ComparisonChecks.equalOrMoreThan(left, comparator).and(ComparisonChecks.equalOrLessThan(right, comparator));
    }

    public static <D extends Comparable<D>> Check<D> betweenInclusive(D left, D right) {
        return ComparisonChecks.betweenInclusive(left, right, Comparable::compareTo);
    }
}

