/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Anything;
import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.CheckBuilder;
import fluent.validation.CheckDsl;
import fluent.validation.ComparisonChecks;
import fluent.validation.NumericChecks;
import fluent.validation.Predicate;
import fluent.validation.ThrowingCheck;
import fluent.validation.Transformation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;

public final class Checks {
    private static final Double DEFAULT_TOLERANCE = Double.parseDouble(System.getProperty("check.default.tolerance", "0.000001"));
    private static final Check<Object> IS_NULL = Checks.equalTo(null);
    private static final Check<Object> NOT_NULL = Checks.not(IS_NULL);
    private static final Check<Object> ANYTHING = new Anything<Object>();

    private Checks() {
    }

    public static <D> Check<D> nullableCondition(Predicate<D> predicate, String expectationDescription) {
        return BasicChecks.nullableCondition(predicate, expectationDescription);
    }

    public static <D> Check<D> require(Check<? super D> requirement, Check<? super D> check) {
        return BasicChecks.require(requirement, check);
    }

    public static <D> Check<D> requireNotNull(Check<D> check) {
        return BasicChecks.requireNotNull(check);
    }

    public static <D> Check<D> check(Predicate<D> predicate, String expectationDescription) {
        return BasicChecks.check(predicate, expectationDescription);
    }

    public static <D> Check<D> not(Check<D> positiveCheck) {
        return BasicChecks.not(positiveCheck);
    }

    public static <D> Check<D> not(D positiveValue) {
        return BasicChecks.not(positiveValue);
    }

    public static <D> Check<D> oneOf(Collection<D> alternatives) {
        return BasicChecks.oneOf(alternatives);
    }

    @SafeVarargs
    public static <D> Check<D> oneOf(D ... alternatives) {
        return BasicChecks.oneOf(alternatives);
    }

    public static <D> Check<D> anyOf(Iterable<Check<? super D>> operands) {
        return BasicChecks.anyOf(operands);
    }

    @SafeVarargs
    public static <D> Check<D> anyOf(Check<? super D> ... operands) {
        return BasicChecks.anyOf(operands);
    }

    public static <D> Check<D> allOf(Iterable<Check<? super D>> operands) {
        return BasicChecks.allOf(operands);
    }

    @SafeVarargs
    public static <D> Check<D> allOf(Check<? super D> ... operands) {
        return BasicChecks.allOf(operands);
    }

    public static <D> Check<D> equalTo(D expectedValue) {
        return BasicChecks.equalTo(expectedValue);
    }

    public static <D> Check<D> is(D expectedValue) {
        return BasicChecks.is(expectedValue);
    }

    public static Check<Object> isNull() {
        return BasicChecks.isNull();
    }

    public static Check<Object> notNull() {
        return BasicChecks.notNull();
    }

    public static Check<Object> anything() {
        return BasicChecks.anything();
    }

    public static <D> Check<D> sameInstance(D expectedInstance) {
        return BasicChecks.sameInstance(expectedInstance);
    }

    public static Check<Object> instanceOf(Class<?> expectedClass) {
        return BasicChecks.instanceOf(expectedClass);
    }

    public static Check<Object> isA(Class<?> expectedClass) {
        return BasicChecks.isA(expectedClass);
    }

    public static Check<Object> isAn(Class<?> expectedClass) {
        return BasicChecks.isAn(expectedClass);
    }

    public static Check<Object> a(Class<?> expectedClass) {
        return BasicChecks.a(expectedClass);
    }

    public static Check<Object> an(Class<?> expectedClass) {
        return BasicChecks.an(expectedClass);
    }

    public static Check<Object> sameClass(Class<?> expectedClass) {
        return BasicChecks.sameClass(expectedClass);
    }

    public static <D> Check<D[]> emptyArray() {
        return BasicChecks.emptyArray();
    }

    public static <D, V> Check<D> transform(Transformation<? super D, V> transformation, Check<? super V> check) {
        return BasicChecks.transform(transformation, check);
    }

    public static <D, V> Check<D> compose(String name, Transformation<? super D, V> transformation, Check<? super V> check) {
        return BasicChecks.compose(name, transformation, check);
    }

    public static <D, V> CheckBuilder<V, Check<D>> has(String name, Transformation<? super D, V> transformation) {
        return BasicChecks.has(name, transformation);
    }

    public static <D, V> CheckBuilder<V, Check<D>> nullableHas(String name, Transformation<? super D, V> transformation) {
        return BasicChecks.nullableHas(name, transformation);
    }

    public static <V> CheckBuilder<V, Check<V>> as(Class<V> type) {
        return BasicChecks.as(type);
    }

    public static Check<Throwable> message(Check<? super String> check) {
        return BasicChecks.message(check);
    }

    public static <D> Check<D> lessThan(D operand, Comparator<D> comparator) {
        return ComparisonChecks.lessThan(operand, comparator);
    }

    public static <D> Check<D> moreThan(D operand, Comparator<D> comparator) {
        return ComparisonChecks.moreThan(operand, comparator);
    }

    public static <D> Check<D> equalOrLessThan(D operand, Comparator<D> comparator) {
        return ComparisonChecks.equalOrLessThan(operand, comparator);
    }

    public static <D> Check<D> equalOrMoreThan(D operand, Comparator<D> comparator) {
        return ComparisonChecks.equalOrMoreThan(operand, comparator);
    }

    public static <D extends Comparable<D>> Check<D> lessThan(D operand) {
        return ComparisonChecks.lessThan(operand);
    }

    public static <D extends Comparable<D>> Check<D> moreThan(D operand) {
        return ComparisonChecks.moreThan(operand);
    }

    public static <D extends Comparable<D>> Check<D> equalOrLessThan(D operand) {
        return ComparisonChecks.equalOrLessThan(operand);
    }

    public static <D extends Comparable<D>> Check<D> equalOrMoreThan(D operand) {
        return ComparisonChecks.equalOrMoreThan(operand);
    }

    public static <D extends Comparable<D>> Check<D> between(D left, D right) {
        return ComparisonChecks.between(left, right);
    }

    public static <D> Check<D> between(D left, D right, Comparator<D> comparator) {
        return ComparisonChecks.between(left, right, comparator);
    }

    public static <D> Check<D> betweenInclusive(D left, D right, Comparator<D> comparator) {
        return ComparisonChecks.betweenInclusive(left, right, comparator);
    }

    public static <D extends Comparable<D>> Check<D> betweenInclusive(D left, D right) {
        return ComparisonChecks.betweenInclusive(left, right);
    }

    public static Check<Double> closeTo(double operand, double precision) {
        return NumericChecks.closeTo(operand, precision);
    }

    public static Check<Float> closeTo(float operand, float precision) {
        return NumericChecks.closeTo(operand, precision);
    }

    public static Check<BigDecimal> closeTo(BigDecimal operand, BigDecimal precision) {
        return NumericChecks.closeTo(operand, precision);
    }

    public static Check<Double> equalTo(Double expectedValue) {
        return NumericChecks.equalTo(expectedValue);
    }

    public static Check<Float> equalTo(Float expectedValue) {
        return NumericChecks.equalTo(expectedValue);
    }

    public static Check<BigDecimal> equalTo(BigDecimal expectedValue) {
        return NumericChecks.equalTo(expectedValue);
    }

    public static ThrowingCheck throwing(Check<? super Throwable> check) {
        return BasicChecks.throwing(check);
    }

    public static ThrowingCheck throwing(Class<? extends Throwable> condition) {
        return BasicChecks.throwing(condition);
    }

    public static <D> Check<D> createBuilder() {
        return BasicChecks.createBuilder();
    }

    public static <D> Check<D> createBuilderWith(Check<D> check) {
        return BasicChecks.createBuilderWith(check);
    }

    public static <D> Check<D> which(Check<D> check) {
        return BasicChecks.which(check);
    }

    public static <D> CheckDsl<D> dsl() {
        return BasicChecks.dsl();
    }
}

