/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.notification.requesttracing;

import fish.payara.notification.requesttracing.EventType;
import fish.payara.notification.requesttracing.RequestTraceSpanLog;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RequestTraceSpan
implements Serializable,
Comparable<RequestTraceSpan> {
    private final SpanContext spanContext;
    private Instant startTime;
    private Instant endTime;
    private long spanDuration;
    private EventType eventType;
    private final Map<String, String> spanTags;
    private final List<RequestTraceSpanLog> spanLogs;
    private String eventName;
    private final List<SpanReference> spanReferences;

    protected RequestTraceSpan() {
        this.spanContext = new SpanContext();
        this.spanTags = new HashMap<String, String>();
        this.spanLogs = new ArrayList<RequestTraceSpanLog>();
        this.spanReferences = new ArrayList<SpanReference>();
    }

    public RequestTraceSpan(String eventName) {
        this(EventType.REQUEST_EVENT, eventName);
    }

    public RequestTraceSpan(EventType eventType, String eventName) {
        this.spanContext = new SpanContext();
        this.startTime = Instant.now();
        this.eventType = eventType;
        this.eventName = eventName;
        this.spanTags = new HashMap<String, String>();
        this.spanLogs = new ArrayList<RequestTraceSpanLog>();
        this.spanReferences = new ArrayList<SpanReference>();
    }

    public RequestTraceSpan(EventType eventType, String eventName, UUID propagatedTraceId, UUID propagatedParentId, SpanContextRelationshipType spanContextRelationship) {
        this.spanContext = new SpanContext(propagatedTraceId);
        this.startTime = Instant.now();
        this.eventType = eventType;
        this.eventName = eventName;
        this.spanTags = new HashMap<String, String>();
        this.spanLogs = new ArrayList<RequestTraceSpanLog>();
        this.spanReferences = new ArrayList<SpanReference>();
        this.spanReferences.add(new SpanReference(new SpanContext(propagatedTraceId, propagatedParentId), spanContextRelationship));
    }

    public UUID getId() {
        return this.spanContext.getSpanId();
    }

    public UUID getTraceId() {
        return this.spanContext.getTraceId();
    }

    public void setTraceId(UUID traceId) {
        this.spanContext.setTraceId(traceId);
    }

    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    public Instant getStartInstant() {
        return this.startTime;
    }

    public void setStartInstant(Instant startTime) {
        this.startTime = startTime;
    }

    public long getTimeOccured() {
        return this.startTime.toEpochMilli();
    }

    public long getSpanDuration() {
        return this.spanDuration;
    }

    public void setSpanDuration(long spanTime) {
        this.spanDuration = spanTime;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void addSpanTag(String name, String value) {
        if (value != null) {
            this.spanTags.put(name, value.replaceAll("\"", "\\\\\""));
        } else {
            this.spanTags.put(name, value);
        }
    }

    public void addSpanLog(RequestTraceSpanLog spanLog) {
        this.spanLogs.add(spanLog);
    }

    public void addSpanReference(SpanContext spanContext, SpanContextRelationshipType relationshipType) {
        this.spanReferences.add(new SpanReference(spanContext, relationshipType));
    }

    public List<SpanReference> getSpanReferences() {
        return this.spanReferences;
    }

    public Instant getTraceEndTime() {
        return this.endTime;
    }

    public void setTraceEndTime(Instant endTime) {
        this.endTime = endTime;
    }

    public void setEventType(EventType spanType) {
        this.eventType = spanType;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("\n{");
        result.append("\"operationName\":\"").append(this.eventName).append("\",").append("\"spanContext\":{").append("\"spanId\":\"").append(this.spanContext.getSpanId()).append("\",").append("\"traceId\":\"").append(this.spanContext.getTraceId()).append("\"");
        result.append("},");
        result.append("\"startTime\":\"").append(this.startTime.atZone(ZoneId.systemDefault()).toString()).append("\",");
        result.append("\"endTime\":\"").append(this.endTime.atZone(ZoneId.systemDefault()).toString()).append("\",");
        result.append("\"traceDuration\":\"").append(this.spanDuration).append("\"");
        if (this.spanTags != null && !this.spanTags.isEmpty()) {
            result.append(",\"spanTags\":[");
            for (String key : this.spanTags.keySet()) {
                result.append("{\"").append(key).append("\": \"").append(this.spanTags.get(key)).append("\"},");
            }
            result.deleteCharAt(result.length() - 1);
            result.append("]");
        }
        if (this.spanLogs != null && !this.spanLogs.isEmpty()) {
            result.append(",\"spanLogs\":[");
            for (RequestTraceSpanLog spanLog : this.spanLogs) {
                Map<String, String> logEntries = spanLog.getLogEntries();
                result.append("{");
                result.append("\"logDetails\":[");
                for (Map.Entry<String, String> logEntry : logEntries.entrySet()) {
                    result.append("{\"");
                    result.append(logEntry.getKey());
                    result.append("\":\"");
                    result.append(logEntry.getValue());
                    result.append("\"},");
                }
                result.deleteCharAt(result.length() - 1);
                result.append("],");
                result.append("\"logTime\":\"");
                result.append(spanLog.getTimeMillis());
                result.append("\"},");
            }
            result.deleteCharAt(result.length() - 1);
            result.append("]");
        }
        if (this.spanReferences != null && !this.spanReferences.isEmpty()) {
            result.append(",\"references\":[");
            for (SpanReference reference : this.spanReferences) {
                result.append("{\"spanContext\":{").append("\"spanId\":\"").append(reference.getReferenceSpanContext().getSpanId()).append("\",").append("\"traceId\":\"").append(reference.getReferenceSpanContext().getTraceId()).append("\"},");
                result.append("\"relationshipType\":\"").append((Object)reference.getSpanContextRelationshipType()).append("\"},");
            }
            result.deleteCharAt(result.length() - 1);
            result.append("]");
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public int compareTo(RequestTraceSpan span) {
        return this.startTime.compareTo(span.startTime);
    }

    public static enum SpanContextRelationshipType {
        ChildOf,
        FollowsFrom;

    }

    public class SpanReference
    implements Serializable {
        private final SpanContext referenceSpanContext;
        private final SpanContextRelationshipType relationshipType;

        private SpanReference(SpanContext referenceSpanContext, SpanContextRelationshipType relationshipType) {
            this.referenceSpanContext = referenceSpanContext;
            this.relationshipType = relationshipType;
        }

        public SpanContext getReferenceSpanContext() {
            return this.referenceSpanContext;
        }

        public SpanContextRelationshipType getSpanContextRelationshipType() {
            return this.relationshipType;
        }
    }

    public class SpanContext
    implements Serializable {
        private final UUID spanId;
        private UUID traceId;
        private final Map<String, String> baggageItems;

        protected SpanContext() {
            this.spanId = UUID.randomUUID();
            this.traceId = UUID.randomUUID();
            this.baggageItems = new HashMap<String, String>();
        }

        protected SpanContext(UUID traceId) {
            this.spanId = UUID.randomUUID();
            this.traceId = traceId;
            this.baggageItems = new HashMap<String, String>();
        }

        protected SpanContext(UUID traceId, UUID parentId) {
            this.spanId = parentId;
            this.traceId = traceId;
            this.baggageItems = new HashMap<String, String>();
        }

        public UUID getSpanId() {
            return this.spanId;
        }

        public UUID getTraceId() {
            return this.traceId;
        }

        public void setTraceId(UUID traceId) {
            this.traceId = traceId;
        }

        public void addBaggageItem(String name, String value) {
            if (value != null) {
                RequestTraceSpan.this.addSpanTag(name, value.replaceAll("\"", "\\\""));
            } else {
                RequestTraceSpan.this.addSpanTag(name, value);
            }
        }

        public Map<String, String> getBaggageItems() {
            return this.baggageItems;
        }
    }
}

