/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.gui.FindBugsFrame;
import edu.umd.cs.findbugs.gui.L10N;
import edu.umd.cs.findbugs.gui.Logger;
import edu.umd.cs.findbugs.gui.SwingGUIBugReporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisRun {
    private Project project;
    private FindBugsFrame frame;
    private String summary;
    private Logger logger;
    private FindBugs findBugs;
    private SwingGUIBugReporter reporter;
    private HashMap<String, DefaultTreeModel> treeModelMap;
    private static final String MISSING_SUMMARY_MESSAGE = "<html><head><title>Could not format summary</title></head><body><h1>Could not format summary</h1><p> Please report this failure to <a href=\"findbugs-discuss@cs.umd.edu\">findbugs-discuss@cs.umd.edu</a>.</body></html>";
    private static final boolean CREATE_SUMMARY = !Boolean.getBoolean("findbugs.noSummary");

    public AnalysisRun(Project project, FindBugsFrame frame) {
        this.project = project;
        this.frame = frame;
        this.logger = frame.getLogger();
        this.reporter = new SwingGUIBugReporter(this);
        this.reporter.setPriorityThreshold(4);
        this.findBugs = new FindBugs((BugReporter)this.reporter, project);
        this.treeModelMap = new HashMap();
    }

    public FindBugsFrame getFrame() {
        return this.frame;
    }

    public void execute(FindBugsProgress progressCallback) throws IOException, InterruptedException {
        this.findBugs.setProgressCallback(progressCallback);
        this.findBugs.setUserPreferences(UserPreferences.getUserPreferences());
        this.findBugs.setAnalysisFeatureSettings(this.frame.getSettingList());
        this.findBugs.execute();
        if (!Boolean.getBoolean("findbugs.noSummary")) {
            this.createSummary(this.reporter.getProjectStats());
        }
    }

    private void createSummary(ProjectStats stats) throws IOException {
        StringWriter html = new StringWriter();
        try {
            stats.transformSummaryToHTML((Writer)html);
            this.summary = html.toString();
        }
        catch (Exception e) {
            this.logger.logMessage(1, MessageFormat.format(L10N.getLocalString("msg.failedtotransform_txt", "Failed to transform summary: {0}"), e.toString()));
            this.summary = MISSING_SUMMARY_MESSAGE;
        }
    }

    public void loadBugsFromFile(File file) throws IOException, DocumentException {
        this.reporter.getBugCollection().readXML(file, this.project);
        this.summary = this.reporter.getBugCollection().getSummaryHTML();
    }

    public void loadBugsFromInputStream(InputStream in) throws IOException, DocumentException {
        this.reporter.getBugCollection().readXML(in, this.project);
        this.summary = this.reporter.getBugCollection().getSummaryHTML();
    }

    public void saveBugsToFile(File file) throws IOException {
        this.reporter.getBugCollection().writeXML(file, this.project);
    }

    public void reportAnalysisErrors() {
        if (this.reporter.errorsOccurred()) {
            this.reporter.getErrorDialog().setSize(750, 520);
            this.reporter.getErrorDialog().setLocationRelativeTo(null);
            this.reporter.getErrorDialog().setVisible(true);
        }
    }

    public Collection<BugInstance> getBugInstances() {
        return this.reporter.getBugCollection().getCollection();
    }

    public void setTreeModel(String groupByOrder, DefaultTreeModel treeModel) {
        this.treeModelMap.put(groupByOrder, treeModel);
    }

    public DefaultTreeModel getTreeModel(String groupByOrder) {
        return this.treeModelMap.get(groupByOrder);
    }

    public String getSummary() {
        return this.summary;
    }
}

