/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.bcel.classfile.Code;

public class InitializationChain
extends BytecodeScanningDetector {
    Set<String> requires = new TreeSet<String>();
    Map<String, Set<String>> classRequires = new TreeMap<String, Set<String>>();
    private BugReporter bugReporter;
    private boolean instanceCreated;
    private int instanceCreatedPC;
    private boolean instanceCreatedWarningGiven;
    private static final boolean DEBUG = Boolean.getBoolean("ic.debug");
    private static final boolean REPORT_CREATE_INSTANCE_BEFORE_FIELDS_ASSIGNED = Boolean.getBoolean("ic.createInstance");

    public InitializationChain(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.instanceCreated = false;
        this.instanceCreatedWarningGiven = false;
        if (!this.getMethodName().equals("<clinit>")) {
            return;
        }
        super.visit(obj);
        this.requires.remove(this.getDottedClassName());
        if (this.getDottedClassName().equals("java.lang.System")) {
            this.requires.add("java.io.FileInputStream");
            this.requires.add("java.io.FileOutputStream");
            this.requires.add("java.io.BufferedInputStream");
            this.requires.add("java.io.BufferedOutputStream");
            this.requires.add("java.io.PrintStream");
        }
        if (!this.requires.isEmpty()) {
            this.classRequires.put(this.getDottedClassName(), this.requires);
            this.requires = new TreeSet<String>();
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 179 && this.getClassConstantOperand().equals(this.getClassName())) {
            String okSig;
            if (REPORT_CREATE_INSTANCE_BEFORE_FIELDS_ASSIGNED && this.instanceCreated && !this.instanceCreatedWarningGiven && !(okSig = "L" + this.getClassName() + ";").equals(this.getSigConstantOperand())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SI_INSTANCE_BEFORE_FINALS_ASSIGNED", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.instanceCreatedPC));
                this.instanceCreatedWarningGiven = true;
            }
        } else if (seen == 187 && this.getClassConstantOperand().equals(this.getClassName())) {
            this.instanceCreated = true;
            this.instanceCreatedPC = this.getPC();
        } else if ((seen == 179 || seen == 178 || seen == 184 || seen == 187) && this.getPC() + 6 < this.codeBytes.length) {
            this.requires.add(this.getDottedClassConstantOperand());
        }
    }

    public void compute() {
        String c;
        Set<String> allClasses = this.classRequires.keySet();
        TreeSet<String> emptyClasses = new TreeSet<String>();
        Iterator<String> i$ = allClasses.iterator();
        while (i$.hasNext()) {
            c = i$.next();
            Set<String> needs = this.classRequires.get(c);
            needs.retainAll(allClasses);
            TreeSet extra = new TreeSet();
            Iterator<String> i$2 = needs.iterator();
            while (i$2.hasNext()) {
                String need = i$2.next();
                extra.addAll(this.classRequires.get(need));
            }
            needs.addAll(extra);
            needs.retainAll(allClasses);
            this.classRequires.put(c, needs);
            if (!needs.isEmpty()) continue;
            emptyClasses.add(c);
        }
        i$ = emptyClasses.iterator();
        while (i$.hasNext()) {
            c = i$.next();
            this.classRequires.remove(c);
        }
    }

    public void report() {
        if (DEBUG) {
            System.out.println("Finishing computation");
        }
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        Set<String> allClasses = this.classRequires.keySet();
        Iterator<String> i$ = allClasses.iterator();
        while (i$.hasNext()) {
            String c = i$.next();
            if (DEBUG) {
                System.out.println("Class " + c + " requires:");
            }
            Iterator<String> i$2 = this.classRequires.get(c).iterator();
            while (i$2.hasNext()) {
                Set<String> s;
                String needs = i$2.next();
                if (DEBUG) {
                    System.out.println("  " + needs);
                }
                if ((s = this.classRequires.get(needs)) == null || !s.contains(c) || c.compareTo(needs) >= 0) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "IC_INIT_CIRCULARITY", 2).addClass(c).addClass(needs));
            }
        }
    }
}

