/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.detect.Analyze;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBadCast2
implements Detector {
    private BugReporter bugReporter;
    private Set<String> concreteCollectionClasses = new HashSet<String>();
    private Set<String> abstractCollectionClasses = new HashSet<String>();
    private Set<String> veryAbstractCollectionClasses = new HashSet<String>();
    private static final boolean DEBUG = false;

    public FindBadCast2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.veryAbstractCollectionClasses.add("java.util.Collection");
        this.veryAbstractCollectionClasses.add("java.util.Iterable");
        this.abstractCollectionClasses.add("java.util.Collection");
        this.abstractCollectionClasses.add("java.util.List");
        this.abstractCollectionClasses.add("java.util.Set");
        this.abstractCollectionClasses.add("java.util.SortedSet");
        this.abstractCollectionClasses.add("java.util.SortedMap");
        this.abstractCollectionClasses.add("java.util.Set");
        this.abstractCollectionClasses.add("java.util.Map");
        this.concreteCollectionClasses.add("java.util.LinkedHashMap");
        this.concreteCollectionClasses.add("java.util.LinkedHashSet");
        this.concreteCollectionClasses.add("java.util.HashMap");
        this.concreteCollectionClasses.add("java.util.HashSet");
        this.concreteCollectionClasses.add("java.util.TreeMap");
        this.concreteCollectionClasses.add("java.util.TreeSet");
        this.concreteCollectionClasses.add("java.util.ArrayList");
        this.concreteCollectionClasses.add("java.util.LinkedList");
        this.concreteCollectionClasses.add("java.util.Hashtable");
        this.concreteCollectionClasses.add("java.util.Vector");
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError(new StringBuffer().append("Detector ").append(this.getClass().getName()).append(" caught exception").toString(), (Throwable)e);
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(192) || bytecodeSet.get(193));
    }

    private boolean isSynthetic(Method m) {
        Attribute[] attrs;
        for (Attribute attr : attrs = m.getAttributes()) {
            if (!(attr instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    private Set<ValueNumber> getParameterValueNumbers(ClassContext classContext, Method method, CFG cfg) throws DataflowAnalysisException, CFGBuilderException {
        int firstParam;
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        ValueNumberFrame vnaFrameAtEntry = (ValueNumberFrame)vnaDataflow.getStartFact(cfg.getEntry());
        HashSet<ValueNumber> paramValueNumberSet = new HashSet<ValueNumber>();
        for (int i = firstParam = method.isStatic() ? 0 : 1; i < vnaFrameAtEntry.getNumLocals(); ++i) {
            paramValueNumberSet.add((ValueNumber)vnaFrameAtEntry.getValue(i));
        }
        return paramValueNumberSet;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        InstructionHandle handle;
        Location location;
        if (this.isSynthetic(method) || !this.prescreen(classContext, method)) {
            return;
        }
        BugAccumulator accumulator = new BugAccumulator(this.bugReporter);
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        IsNullValueDataflow isNullDataflow = classContext.getIsNullValueDataflow(method);
        Set<ValueNumber> paramValueNumberSet = null;
        ValueNumberDataflow vnaDataflow = null;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        String methodName = new StringBuffer().append(methodGen.getClassName()).append(".").append(methodGen.getName()).toString();
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        HashSet<SourceLineAnnotation> haveInstanceOf = new HashSet<SourceLineAnnotation>();
        HashSet<SourceLineAnnotation> haveCast = new HashSet<SourceLineAnnotation>();
        HashSet<SourceLineAnnotation> haveMultipleInstanceOf = new HashSet<SourceLineAnnotation>();
        HashSet<SourceLineAnnotation> haveMultipleCast = new HashSet<SourceLineAnnotation>();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            location = (Location)i.next();
            handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof CHECKCAST) && !(ins instanceof INSTANCEOF)) continue;
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
            if (ins instanceof CHECKCAST) {
                if (haveCast.add(sourceLineAnnotation)) continue;
                haveMultipleCast.add(sourceLineAnnotation);
                continue;
            }
            if (haveInstanceOf.add(sourceLineAnnotation)) continue;
            haveMultipleInstanceOf.add(sourceLineAnnotation);
        }
        i = cfg.locationIterator();
        while (i.hasNext()) {
            ReferenceType refType;
            Type castType;
            Type operandType;
            TypeFrame frame;
            location = (Location)i.next();
            handle = location.getHandle();
            int pc = handle.getPosition();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof CHECKCAST) && !(ins instanceof INSTANCEOF) || handle.getNext() == null) continue;
            Instruction nextIns = handle.getNext().getInstruction();
            boolean isCast = ins instanceof CHECKCAST;
            String kind = isCast ? "checkedCast" : "instanceof";
            int occurrences = cfg.getLocationsContainingInstructionWithOffset(pc).size();
            boolean split = occurrences > 1;
            IsNullValueFrame nullFrame = isNullDataflow.getFactAtLocation(location);
            IsNullValue operandNullness = (IsNullValue)nullFrame.getTopValue();
            if (split && !isCast || !(frame = typeDataflow.getFactAtLocation(location)).isValid() || (operandType = (Type)frame.getTopValue()).equals((Object)TopType.instance()) || !((castType = ((TypedInstruction)ins).getType(cpg)) instanceof ReferenceType)) continue;
            String castSig = castType.getSignature();
            if (operandType.equals((Object)NullType.instance()) || operandNullness.isDefinitelyNull()) {
                SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
                String castName = castSig.substring(1, castSig.length() - 1).replace('/', '.');
                if (isCast) continue;
                accumulator.accumulateBug(new BugInstance((Detector)this, "NP_NULL_INSTANCEOF", 2).addClassAndMethod(methodGen, sourceFile).addClass(castName), sourceLineAnnotation);
                continue;
            }
            if (!(operandType instanceof ReferenceType) || (refType = (ReferenceType)operandType).equals((Object)castType)) continue;
            String refSig = refType.getSignature();
            String castSig2 = castSig;
            String refSig2 = refSig;
            while (castSig2.charAt(0) == '[' && refSig2.charAt(0) == '[') {
                castSig2 = castSig2.substring(1);
                refSig2 = refSig2.substring(1);
            }
            if (refSig2.equals("Ljava/lang/Object;") && !(nextIns instanceof InvokeInstruction) || refSig2.charAt(0) != 'L' || castSig2.charAt(0) != 'L') continue;
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
            if (isCast && haveMultipleCast.contains(sourceLineAnnotation) || !isCast && haveMultipleInstanceOf.contains(sourceLineAnnotation)) continue;
            String castName = castSig2.substring(1, castSig2.length() - 1).replace('/', '.');
            String refName = refSig2.substring(1, refSig2.length() - 1).replace('/', '.');
            if (vnaDataflow == null) {
                vnaDataflow = classContext.getValueNumberDataflow(method);
            }
            ValueNumberFrame vFrame = vnaDataflow.getFactAtLocation(location);
            if (paramValueNumberSet == null) {
                paramValueNumberSet = this.getParameterValueNumbers(classContext, method, cfg);
            }
            boolean isParameter = paramValueNumberSet.contains(vFrame.getTopValue());
            try {
                boolean completeInformation;
                boolean castToAbstractCollection;
                JavaClass castJavaClass = Repository.lookupClass((String)castName);
                JavaClass refJavaClass = Repository.lookupClass((String)refName);
                boolean upcast = Repository.instanceOf((JavaClass)refJavaClass, (JavaClass)castJavaClass);
                if (upcast) {
                    if (isCast) continue;
                    accumulator.accumulateBug(new BugInstance((Detector)this, "BC_VACUOUS_INSTANCEOF", 2).addClassAndMethod(methodGen, sourceFile).addClass(refName.replace('/', '.')).addClass(castName.replace('/', '.')), sourceLineAnnotation);
                    continue;
                }
                boolean downcast = Repository.instanceOf((JavaClass)castJavaClass, (JavaClass)refJavaClass);
                if (refName.equals("java.lang.Object")) continue;
                double rank = Analyze.deepInstanceOf(refJavaClass, castJavaClass);
                boolean castToConcreteCollection = this.concreteCollectionClasses.contains(castName) && this.abstractCollectionClasses.contains(refName);
                boolean bl = castToAbstractCollection = this.abstractCollectionClasses.contains(castName) && this.veryAbstractCollectionClasses.contains(refName);
                if (castToConcreteCollection && rank > 0.6) {
                    rank = (rank + 0.6) / 2.0;
                } else if (castToAbstractCollection && rank > 0.3) {
                    rank = (rank + 0.3) / 2.0;
                }
                boolean bl2 = completeInformation = !castJavaClass.isInterface() && !refJavaClass.isInterface() || refJavaClass.isFinal() || castJavaClass.isFinal();
                if (!downcast && completeInformation) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, isCast ? "BC_IMPOSSIBLE_CAST" : "BC_IMPOSSIBLE_INSTANCEOF", isCast ? 1 : 2).addClassAndMethod(methodGen, sourceFile).addClass(refName.replace('/', '.')).addClass(castName.replace('/', '.')).addSourceLine(sourceLineAnnotation));
                    continue;
                }
                if (!isCast || !(rank < 0.9)) continue;
                int priority = 2;
                priority = rank > 0.75 ? (priority += 2) : (rank > 0.5 ? ++priority : (rank > 0.25 ? (priority += 0) : --priority));
                if (methodGen.getClassName().startsWith(refName) || methodGen.getClassName().startsWith(castName)) {
                    ++priority;
                }
                if (castJavaClass.isInterface() && !castToAbstractCollection) {
                    ++priority;
                }
                if (castToConcreteCollection && this.veryAbstractCollectionClasses.contains(refName)) {
                    --priority;
                }
                if (priority <= 3 && !castToAbstractCollection && !castToConcreteCollection && (refJavaClass.isInterface() || refJavaClass.isAbstract())) {
                    ++priority;
                }
                if (methodGen.getName().equals("compareTo")) {
                    ++priority;
                } else if (methodGen.isPublic() && isParameter) {
                    --priority;
                }
                if (priority < 1) {
                    priority = 1;
                }
                if (priority > 3) continue;
                String bug = "BC_UNCONFIRMED_CAST";
                if (castToConcreteCollection) {
                    bug = "BC_BAD_CAST_TO_CONCRETE_COLLECTION";
                } else if (castToAbstractCollection) {
                    bug = "BC_BAD_CAST_TO_ABSTRACT_COLLECTION";
                }
                accumulator.accumulateBug(new BugInstance((Detector)this, bug, priority).addClassAndMethod(methodGen, sourceFile).addClass(refName.replace('/', '.')).addClass(castName.replace('/', '.')), sourceLineAnnotation);
            }
            catch (ClassNotFoundException e) {}
        }
        accumulator.reportAccumulatedBugs();
    }

    public void report() {
    }
}

