/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.EmergencySource;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Emergency {
    private String location = null;
    private OffsetDateTime published = null;
    private String description = null;
    private String extent = null;
    private String type = null;
    private String url = null;
    private String latitude = null;
    private String longitude = null;
    private List<EmergencySource> sources = new ArrayList<EmergencySource>();

    public Emergency location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Emergency published(OffsetDateTime published) {
        this.published = published;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public OffsetDateTime getPublished() {
        return this.published;
    }

    public void setPublished(OffsetDateTime published) {
        this.published = published;
    }

    public Emergency description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Emergency extent(String extent) {
        this.extent = extent;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getExtent() {
        return this.extent;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    public Emergency type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Emergency url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Emergency latitude(String latitude) {
        this.latitude = latitude;
        return this;
    }

    @ApiModelProperty(example="null", value="Emergency latitude coordinate.")
    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public Emergency longitude(String longitude) {
        this.longitude = longitude;
        return this;
    }

    @ApiModelProperty(example="null", value="Emergency longitude coordinate.")
    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public Emergency sources(List<EmergencySource> sources) {
        this.sources = sources;
        return this;
    }

    @ApiModelProperty(example="null", value="List of emergency source")
    public List<EmergencySource> getSources() {
        return this.sources;
    }

    public void setSources(List<EmergencySource> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Emergency emergency = (Emergency)o;
        return Objects.equals(this.location, emergency.location) && Objects.equals(this.published, emergency.published) && Objects.equals(this.description, emergency.description) && Objects.equals(this.extent, emergency.extent) && Objects.equals(this.type, emergency.type) && Objects.equals(this.url, emergency.url) && Objects.equals(this.latitude, emergency.latitude) && Objects.equals(this.longitude, emergency.longitude) && Objects.equals(this.sources, emergency.sources);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.published, this.description, this.extent, this.type, this.url, this.latitude, this.longitude, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Emergency {\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    extent: ").append(this.toIndentedString(this.extent)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    latitude: ").append(this.toIndentedString(this.latitude)).append("\n");
        sb.append("    longitude: ").append(this.toIndentedString(this.longitude)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

