/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.Address;
import fi.metatavu.kuntaapi.server.rest.model.Email;
import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import fi.metatavu.kuntaapi.server.rest.model.Municipality;
import fi.metatavu.kuntaapi.server.rest.model.OrganizationService;
import fi.metatavu.kuntaapi.server.rest.model.Phone;
import fi.metatavu.kuntaapi.server.rest.model.WebPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Organization")
public class Organization {
    private String id = null;
    private Municipality municipality = null;
    private String organizationType = null;
    private String businessCode = null;
    private String businessName = null;
    private List<LocalizedValue> names = new ArrayList<LocalizedValue>();
    private String displayNameType = null;
    private List<LocalizedValue> descriptions = new ArrayList<LocalizedValue>();
    private List<Email> emailAddresses = new ArrayList<Email>();
    private List<Phone> phoneNumbers = new ArrayList<Phone>();
    private List<WebPage> webPages = new ArrayList<WebPage>();
    private List<Address> addresses = new ArrayList<Address>();
    private String publishingStatus = null;
    private String parentOrganization = null;
    private List<OrganizationService> services = new ArrayList<OrganizationService>();

    public Organization id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Entity identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Organization municipality(Municipality municipality) {
        this.municipality = municipality;
        return this;
    }

    @ApiModelProperty(example="null", value="Municipality including municipality code and a localized list of municipality names.")
    public Municipality getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(Municipality municipality) {
        this.municipality = municipality;
    }

    public Organization organizationType(String organizationType) {
        this.organizationType = organizationType;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization type (State, Municipality, RegionalOrganization, Organization, Company).")
    public String getOrganizationType() {
        return this.organizationType;
    }

    public void setOrganizationType(String organizationType) {
        this.organizationType = organizationType;
    }

    public Organization businessCode(String businessCode) {
        this.businessCode = businessCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization business code (Y-tunnus).")
    public String getBusinessCode() {
        return this.businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public Organization businessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization business name (name used for business code).")
    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public Organization names(List<LocalizedValue> names) {
        this.names = names;
        return this;
    }

    @ApiModelProperty(example="null", value="List of organization names.")
    public List<LocalizedValue> getNames() {
        return this.names;
    }

    public void setNames(List<LocalizedValue> names) {
        this.names = names;
    }

    public Organization displayNameType(String displayNameType) {
        this.displayNameType = displayNameType;
        return this;
    }

    @ApiModelProperty(example="null", value="Display name type (Name or AlternateName). Which name type should be used as the display name for the organization (OrganizationNames list).")
    public String getDisplayNameType() {
        return this.displayNameType;
    }

    public void setDisplayNameType(String displayNameType) {
        this.displayNameType = displayNameType;
    }

    public Organization descriptions(List<LocalizedValue> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of organizations descriptions.")
    public List<LocalizedValue> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<LocalizedValue> descriptions) {
        this.descriptions = descriptions;
    }

    public Organization emailAddresses(List<Email> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    @ApiModelProperty(example="null", value="List of organizations email addresses.")
    public List<Email> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(List<Email> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public Organization phoneNumbers(List<Phone> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="List of organizations phone numbers.")
    public List<Phone> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<Phone> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public Organization webPages(List<WebPage> webPages) {
        this.webPages = webPages;
        return this;
    }

    @ApiModelProperty(example="null", value="List of organizations web pages.")
    public List<WebPage> getWebPages() {
        return this.webPages;
    }

    public void setWebPages(List<WebPage> webPages) {
        this.webPages = webPages;
    }

    public Organization addresses(List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    @ApiModelProperty(example="null", value="List of organizations addresses.")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public Organization publishingStatus(String publishingStatus) {
        this.publishingStatus = publishingStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Publishing status (Draft, Published, Deleted, Modified and OldPublished).")
    public String getPublishingStatus() {
        return this.publishingStatus;
    }

    public void setPublishingStatus(String publishingStatus) {
        this.publishingStatus = publishingStatus;
    }

    public Organization parentOrganization(String parentOrganization) {
        this.parentOrganization = parentOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="Organizations parent organization identifier if exists.")
    public String getParentOrganization() {
        return this.parentOrganization;
    }

    public void setParentOrganization(String parentOrganization) {
        this.parentOrganization = parentOrganization;
    }

    public Organization services(List<OrganizationService> services) {
        this.services = services;
        return this;
    }

    @ApiModelProperty(example="null", value="List of organizations services.")
    public List<OrganizationService> getServices() {
        return this.services;
    }

    public void setServices(List<OrganizationService> services) {
        this.services = services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.id, organization.id) && Objects.equals(this.municipality, organization.municipality) && Objects.equals(this.organizationType, organization.organizationType) && Objects.equals(this.businessCode, organization.businessCode) && Objects.equals(this.businessName, organization.businessName) && Objects.equals(this.names, organization.names) && Objects.equals(this.displayNameType, organization.displayNameType) && Objects.equals(this.descriptions, organization.descriptions) && Objects.equals(this.emailAddresses, organization.emailAddresses) && Objects.equals(this.phoneNumbers, organization.phoneNumbers) && Objects.equals(this.webPages, organization.webPages) && Objects.equals(this.addresses, organization.addresses) && Objects.equals(this.publishingStatus, organization.publishingStatus) && Objects.equals(this.parentOrganization, organization.parentOrganization) && Objects.equals(this.services, organization.services);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.municipality, this.organizationType, this.businessCode, this.businessName, this.names, this.displayNameType, this.descriptions, this.emailAddresses, this.phoneNumbers, this.webPages, this.addresses, this.publishingStatus, this.parentOrganization, this.services);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    municipality: ").append(this.toIndentedString(this.municipality)).append("\n");
        sb.append("    organizationType: ").append(this.toIndentedString(this.organizationType)).append("\n");
        sb.append("    businessCode: ").append(this.toIndentedString(this.businessCode)).append("\n");
        sb.append("    businessName: ").append(this.toIndentedString(this.businessName)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    displayNameType: ").append(this.toIndentedString(this.displayNameType)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    emailAddresses: ").append(this.toIndentedString(this.emailAddresses)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    webPages: ").append(this.toIndentedString(this.webPages)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    publishingStatus: ").append(this.toIndentedString(this.publishingStatus)).append("\n");
        sb.append("    parentOrganization: ").append(this.toIndentedString(this.parentOrganization)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

