/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest;

import fi.metatavu.kuntaapi.server.rest.AbstractApi;
import fi.metatavu.kuntaapi.server.rest.model.Agency;
import fi.metatavu.kuntaapi.server.rest.model.Announcement;
import fi.metatavu.kuntaapi.server.rest.model.Attachment;
import fi.metatavu.kuntaapi.server.rest.model.Banner;
import fi.metatavu.kuntaapi.server.rest.model.Contact;
import fi.metatavu.kuntaapi.server.rest.model.Event;
import fi.metatavu.kuntaapi.server.rest.model.FileDef;
import fi.metatavu.kuntaapi.server.rest.model.Fragment;
import fi.metatavu.kuntaapi.server.rest.model.Job;
import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import fi.metatavu.kuntaapi.server.rest.model.Menu;
import fi.metatavu.kuntaapi.server.rest.model.MenuItem;
import fi.metatavu.kuntaapi.server.rest.model.NewsArticle;
import fi.metatavu.kuntaapi.server.rest.model.Organization;
import fi.metatavu.kuntaapi.server.rest.model.OrganizationService;
import fi.metatavu.kuntaapi.server.rest.model.OrganizationSetting;
import fi.metatavu.kuntaapi.server.rest.model.Page;
import fi.metatavu.kuntaapi.server.rest.model.Route;
import fi.metatavu.kuntaapi.server.rest.model.Schedule;
import fi.metatavu.kuntaapi.server.rest.model.Stop;
import fi.metatavu.kuntaapi.server.rest.model.Tile;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Path(value="/organizations")
@Api(description="the organizations API")
@Consumes(value={"application/json;charset=utf-8"})
@Produces(value={"application/json;charset=utf-8"})
public abstract class OrganizationsApi
extends AbstractApi {
    @POST
    @Path(value="/{organizationId}/organizationServices")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Create organization service", notes="Create organization service", response=Organization.class, tags={"Organizations", "OrganizationServices"})
    @ApiResponses(value={@ApiResponse(code=200, message="Created organization service", response=Organization.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Organization.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Organization.class), @ApiResponse(code=500, message="Internal server error", response=Organization.class)})
    public abstract Response createOrganizationService(@PathParam(value="organizationId") String var1, OrganizationService var2, @Context Request var3);

    @POST
    @Path(value="/{organizationId}/settings/")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Creates organization setting", notes="Creates organization setting ", response=OrganizationSetting.class, tags={"Settings"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns create organization setting", response=OrganizationSetting.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=OrganizationSetting.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=OrganizationSetting.class), @ApiResponse(code=500, message="Internal server error", response=OrganizationSetting.class)})
    public abstract Response createOrganizationSetting(@PathParam(value="organizationId") String var1, OrganizationSetting var2, @Context Request var3);

    @DELETE
    @Path(value="/{organizationId}/settings/{settingId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Deletes an organization setting", notes="Deletes an organization setting ", response=void.class, tags={"Settings"})
    @ApiResponses(value={@ApiResponse(code=204, message="Successful removal", response=void.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=void.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=void.class), @ApiResponse(code=500, message="Internal server error", response=void.class)})
    public abstract Response deleteOrganizationSetting(@PathParam(value="organizationId") String var1, @PathParam(value="settingId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Find organization", notes="Find organization", response=Organization.class, tags={"Organizations"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an organization", response=Organization.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Organization.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Organization.class), @ApiResponse(code=500, message="Internal server error", response=Organization.class)})
    public abstract Response findOrganization(@PathParam(value="organizationId") String var1, @Context Request var2);

    @GET
    @Path(value="/{organizationId}/announcements/{announcementId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds an organizations announcement", notes="Finds organization's single announcement ", response=Announcement.class, tags={"Announcements"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single announcement", response=Announcement.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Announcement.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Announcement.class), @ApiResponse(code=500, message="Internal server error", response=Announcement.class)})
    public abstract Response findOrganizationAnnouncement(@PathParam(value="organizationId") String var1, @PathParam(value="announcementId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/banners/{bannerId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations banner", notes="Finds single organization banner ", response=NewsArticle.class, tags={"Banners"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization banner", response=NewsArticle.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=NewsArticle.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=NewsArticle.class), @ApiResponse(code=500, message="Internal server error", response=NewsArticle.class)})
    public abstract Response findOrganizationBanner(@PathParam(value="organizationId") String var1, @PathParam(value="bannerId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/banners/{bannerId}/images/{imageId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns a single organiztion banner image", notes="Returns a single organiztion banner image ", response=Attachment.class, tags={"Banners"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an organization banner image", response=Attachment.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class), @ApiResponse(code=500, message="Internal server error", response=Attachment.class)})
    public abstract Response findOrganizationBannerImage(@PathParam(value="organizationId") String var1, @PathParam(value="bannerId") String var2, @PathParam(value="imageId") String var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/contacts/{contactId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds an organizations contact", notes="Finds organization's single contact ", response=Contact.class, tags={"Contacts"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single contact", response=Contact.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Contact.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Contact.class), @ApiResponse(code=500, message="Internal server error", response=Contact.class)})
    public abstract Response findOrganizationContact(@PathParam(value="organizationId") String var1, @PathParam(value="contactId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/events/{eventId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns organizations event by id", notes="Returns organizations event by id ", response=Event.class, tags={"Events"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single event", response=Event.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Event.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Event.class), @ApiResponse(code=500, message="Internal server error", response=Event.class)})
    public abstract Response findOrganizationEvent(@PathParam(value="organizationId") String var1, @PathParam(value="eventId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/events/{eventId}/images/{imageId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns an event image", notes="Returns an event image  ", response=Attachment.class, tags={"Events"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an event image", response=Attachment.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class), @ApiResponse(code=500, message="Internal server error", response=Attachment.class)})
    public abstract Response findOrganizationEventImage(@PathParam(value="organizationId") String var1, @PathParam(value="eventId") String var2, @PathParam(value="imageId") String var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/files/{fileId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations file", notes="Finds single organization file ", response=FileDef.class, tags={"Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization file", response=FileDef.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=FileDef.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=FileDef.class), @ApiResponse(code=500, message="Internal server error", response=FileDef.class)})
    public abstract Response findOrganizationFile(@PathParam(value="organizationId") String var1, @PathParam(value="fileId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/fragments/{fragmentId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations page fragment", notes="Finds single organization page fragment ", response=Fragment.class, tags={"Fragments"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization page fragment", response=Fragment.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Fragment.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Fragment.class), @ApiResponse(code=500, message="Internal server error", response=Fragment.class)})
    public abstract Response findOrganizationFragment(@PathParam(value="organizationId") String var1, @PathParam(value="fragmentId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/jobs/{jobId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations job", notes="Finds single organization job ", response=Job.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization job", response=Job.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Job.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Job.class), @ApiResponse(code=500, message="Internal server error", response=Job.class)})
    public abstract Response findOrganizationJob(@PathParam(value="organizationId") String var1, @PathParam(value="jobId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/menus/{menuId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations menu", notes="Finds single organization menu ", response=Menu.class, tags={"Menus"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization menu", response=Menu.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Menu.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Menu.class), @ApiResponse(code=500, message="Internal server error", response=Menu.class)})
    public abstract Response findOrganizationMenu(@PathParam(value="organizationId") String var1, @PathParam(value="menuId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/menus/{menuId}/items/{menuItemId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organization menu item", notes="Finds single organization menu item ", response=MenuItem.class, tags={"Menus"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization menu item", response=MenuItem.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=MenuItem.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=MenuItem.class), @ApiResponse(code=500, message="Internal server error", response=MenuItem.class)})
    public abstract Response findOrganizationMenuItem(@PathParam(value="organizationId") String var1, @PathParam(value="menuId") String var2, @PathParam(value="menuItemId") String var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/news/{newsArticleId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations news article", notes="Finds organizations single news article ", response=NewsArticle.class, tags={"News"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single news article", response=NewsArticle.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=NewsArticle.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=NewsArticle.class), @ApiResponse(code=500, message="Internal server error", response=NewsArticle.class)})
    public abstract Response findOrganizationNewsArticle(@PathParam(value="organizationId") String var1, @PathParam(value="newsArticleId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/news/{newsArticleId}/images/{imageId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns an news article image", notes="Returns an news article image ", response=Attachment.class, tags={"News"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an news article image", response=Attachment.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class), @ApiResponse(code=500, message="Internal server error", response=Attachment.class)})
    public abstract Response findOrganizationNewsArticleImage(@PathParam(value="organizationId") String var1, @PathParam(value="newsArticleId") String var2, @PathParam(value="imageId") String var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/pages/{pageId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations page", notes="Finds single organization page ", response=Page.class, tags={"Pages"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization page", response=Page.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Page.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Page.class), @ApiResponse(code=500, message="Internal server error", response=Page.class)})
    public abstract Response findOrganizationPage(@PathParam(value="organizationId") String var1, @PathParam(value="pageId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/pages/{pageId}/content")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns organizations page content in all available languages", notes="Returns single organization page content in all available languages ", response=LocalizedValue.class, responseContainer="List", tags={"Pages"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns single page content in all available languages", response=LocalizedValue.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=LocalizedValue.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=LocalizedValue.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=LocalizedValue.class, responseContainer="List")})
    public abstract Response findOrganizationPageContent(@PathParam(value="organizationId") String var1, @PathParam(value="pageId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/pages/{pageId}/images/{imageId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns a single organiztion page image", notes="Returns a single organiztion page image ", response=Attachment.class, tags={"Pages"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an organization page image", response=Attachment.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class), @ApiResponse(code=500, message="Internal server error", response=Attachment.class)})
    public abstract Response findOrganizationPageImage(@PathParam(value="organizationId") String var1, @PathParam(value="pageId") String var2, @PathParam(value="imageId") String var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/transportAgencies/{agencyId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds an organizations public transport agency", notes="Finds organization's single public transport agency ", response=Agency.class, tags={"Public transport"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single public transport agency", response=Agency.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Agency.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Agency.class), @ApiResponse(code=500, message="Internal server error", response=Agency.class)})
    public abstract Response findOrganizationPublicTransportAgency(@PathParam(value="organizationId") String var1, @PathParam(value="agencyId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/transportRoutes/{routeId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds an organizations public transport route", notes="Finds organization's single public transport route ", response=Route.class, tags={"Public transport"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single public transport route", response=Route.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Route.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Route.class), @ApiResponse(code=500, message="Internal server error", response=Route.class)})
    public abstract Response findOrganizationPublicTransportRoute(@PathParam(value="organizationId") String var1, @PathParam(value="routeId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/transportRoutes/{routeId}/stops/{stopId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds a stop of organizations public transport route", notes="Finds a stop of organizations public transport route ", response=Stop.class, tags={"Public transport"})
    @ApiResponses(value={@ApiResponse(code=200, message="returns organizations public transport route stop", response=Stop.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Stop.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Stop.class), @ApiResponse(code=500, message="Internal server error", response=Stop.class)})
    public abstract Response findOrganizationPublicTransportRouteStop(@PathParam(value="organizationId") String var1, @PathParam(value="routeId") String var2, @PathParam(value="stopId") String var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/transportSchedules/{scheduleId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations public transport schedule", notes="Finds organizations public transport schedule ", response=Schedule.class, tags={"Public transport"})
    @ApiResponses(value={@ApiResponse(code=200, message="returns an organizations public transport schedule", response=Schedule.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Schedule.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Schedule.class), @ApiResponse(code=500, message="Internal server error", response=Schedule.class)})
    public abstract Response findOrganizationPublicTransportSchedule(@PathParam(value="organizationId") String var1, @PathParam(value="scheduleId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/organizationServices/{organizationServiceId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds a organization service by id", notes="Find an organization service", response=OrganizationService.class, tags={"Organizations", "OrganizationServices"})
    @ApiResponses(value={@ApiResponse(code=200, message="An organization service", response=OrganizationService.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=OrganizationService.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=OrganizationService.class), @ApiResponse(code=404, message="Resource was not found from the server", response=OrganizationService.class), @ApiResponse(code=500, message="Internal server error", response=OrganizationService.class)})
    public abstract Response findOrganizationService(@PathParam(value="organizationId") String var1, @PathParam(value="organizationServiceId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/settings/{settingId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations setting", notes="Finds single organization setting ", response=OrganizationSetting.class, tags={"Settings"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization setting", response=OrganizationSetting.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=OrganizationSetting.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=OrganizationSetting.class), @ApiResponse(code=500, message="Internal server error", response=OrganizationSetting.class)})
    public abstract Response findOrganizationSetting(@PathParam(value="organizationId") String var1, @PathParam(value="settingId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/tiles/{tileId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds organizations tile", notes="Finds single organization tile ", response=Tile.class, tags={"Tiles"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single organization tile", response=Tile.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Tile.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Tile.class), @ApiResponse(code=500, message="Internal server error", response=Tile.class)})
    public abstract Response findOrganizationTile(@PathParam(value="organizationId") String var1, @PathParam(value="tileId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/tiles/{tileId}/images/{imageId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns a single organiztion tile image", notes="Returns a single organiztion tile image ", response=Attachment.class, tags={"Tiles"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an organization tile image", response=Attachment.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class), @ApiResponse(code=500, message="Internal server error", response=Attachment.class)})
    public abstract Response findOrganizationTileImage(@PathParam(value="organizationId") String var1, @PathParam(value="tileId") String var2, @PathParam(value="imageId") String var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/banners/{bannerId}/images/{imageId}/data")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Returns an organization banner image data", notes="Returns an organization banner image data ", response=byte[].class, tags={"Banners"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an organization banner image data", response=byte[].class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=byte[].class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=byte[].class), @ApiResponse(code=500, message="Internal server error", response=byte[].class)})
    public abstract Response getOrganizationBannerImageData(@PathParam(value="organizationId") String var1, @PathParam(value="bannerId") String var2, @PathParam(value="imageId") String var3, @QueryParam(value="size") Integer var4, @Context Request var5);

    @GET
    @Path(value="/{organizationId}/events/{eventId}/images/{imageId}/data")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Returns an event image data", notes="Returns an event image data ", response=byte[].class, tags={"Events"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an event image data", response=byte[].class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=byte[].class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=byte[].class), @ApiResponse(code=500, message="Internal server error", response=byte[].class)})
    public abstract Response getOrganizationEventImageData(@PathParam(value="organizationId") String var1, @PathParam(value="eventId") String var2, @PathParam(value="imageId") String var3, @QueryParam(value="size") Integer var4, @Context Request var5);

    @GET
    @Path(value="/{organizationId}/files/{fileId}/data")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Returns an organization file data", notes="Returns an organization file data ", response=byte[].class, tags={"Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an organization file data", response=byte[].class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=byte[].class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=byte[].class), @ApiResponse(code=500, message="Internal server error", response=byte[].class)})
    public abstract Response getOrganizationFileData(@PathParam(value="organizationId") String var1, @PathParam(value="fileId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/news/{newsArticleId}/images/{imageId}/data")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Returns a news article image data", notes="Returns a news article image data ", response=byte[].class, tags={"News"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a news article image data", response=byte[].class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=byte[].class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=byte[].class), @ApiResponse(code=500, message="Internal server error", response=byte[].class)})
    public abstract Response getOrganizationNewsArticleImageData(@PathParam(value="organizationId") String var1, @PathParam(value="newsArticleId") String var2, @PathParam(value="imageId") String var3, @QueryParam(value="size") Integer var4, @Context Request var5);

    @GET
    @Path(value="/{organizationId}/pages/{pageId}/images/{imageId}/data")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Returns an organization page image data", notes="Returns an organization page image data ", response=byte[].class, tags={"Pages"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an organization page image data", response=byte[].class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=byte[].class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=byte[].class), @ApiResponse(code=500, message="Internal server error", response=byte[].class)})
    public abstract Response getOrganizationPageImageData(@PathParam(value="organizationId") String var1, @PathParam(value="pageId") String var2, @PathParam(value="imageId") String var3, @QueryParam(value="size") Integer var4, @Context Request var5);

    @GET
    @Path(value="/{organizationId}/tiles/{tileId}/images/{imageId}/data")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Returns an organization tile image data", notes="Returns an organization tile image data ", response=byte[].class, tags={"Tiles"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an organization tile image data", response=byte[].class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=byte[].class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=byte[].class), @ApiResponse(code=500, message="Internal server error", response=byte[].class)})
    public abstract Response getOrganizationTileImageData(@PathParam(value="organizationId") String var1, @PathParam(value="tileId") String var2, @PathParam(value="imageId") String var3, @QueryParam(value="size") Integer var4, @Context Request var5);

    @GET
    @Path(value="/{organizationId}/announcements")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations announcements", notes="Lists organizations announcements ", response=Announcement.class, responseContainer="List", tags={"Announcements"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of announcements", response=Announcement.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Announcement.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Announcement.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Announcement.class, responseContainer="List")})
    public abstract Response listOrganizationAnnouncements(@PathParam(value="organizationId") String var1, @QueryParam(value="slug") String var2, @QueryParam(value="firstResult") Integer var3, @QueryParam(value="maxResults") Integer var4, @QueryParam(value="sortBy") String var5, @QueryParam(value="sortDir") String var6, @Context Request var7);

    @GET
    @Path(value="/{organizationId}/banners/{bannerId}/images")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns a list of organization banner images", notes="Returns a list of organization banner images ", response=Attachment.class, responseContainer="List", tags={"Banners"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns list of organization banner images", response=Attachment.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Attachment.class, responseContainer="List")})
    public abstract Response listOrganizationBannerImages(@PathParam(value="organizationId") String var1, @PathParam(value="bannerId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/banners")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations banners", notes="Lists organizations banners ", response=Banner.class, responseContainer="List", tags={"Banners"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of banners", response=Banner.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Banner.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Banner.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Banner.class, responseContainer="List")})
    public abstract Response listOrganizationBanners(@PathParam(value="organizationId") String var1, @Context Request var2);

    @GET
    @Path(value="/{organizationId}/contacts")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations contacts", notes="Lists organizations contacts ", response=Contact.class, responseContainer="List", tags={"Contacts"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of contacts", response=Contact.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Contact.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Contact.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Contact.class, responseContainer="List")})
    public abstract Response listOrganizationContacts(@PathParam(value="organizationId") String var1, @Context Request var2);

    @GET
    @Path(value="/{organizationId}/events/{eventId}/images")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns list of event images", notes="Returns list of event images ", response=Attachment.class, responseContainer="List", tags={"Events"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of event images", response=Attachment.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Attachment.class, responseContainer="List")})
    public abstract Response listOrganizationEventImages(@PathParam(value="organizationId") String var1, @PathParam(value="eventId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/events")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations events", notes="Lists organizations events ", response=Event.class, responseContainer="List", tags={"Events"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of events", response=Event.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Event.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Event.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Event.class, responseContainer="List")})
    public abstract Response listOrganizationEvents(@PathParam(value="organizationId") String var1, @QueryParam(value="startBefore") String var2, @QueryParam(value="startAfter") String var3, @QueryParam(value="endBefore") String var4, @QueryParam(value="endAfter") String var5, @QueryParam(value="firstResult") Integer var6, @QueryParam(value="maxResults") Integer var7, @QueryParam(value="orderBy") String var8, @QueryParam(value="orderDir") String var9, @Context Request var10);

    @GET
    @Path(value="/{organizationId}/files")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations files", notes="Lists organizations files ", response=FileDef.class, responseContainer="List", tags={"Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of organizations files", response=FileDef.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=FileDef.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=FileDef.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=FileDef.class, responseContainer="List")})
    public abstract Response listOrganizationFiles(@PathParam(value="organizationId") String var1, @QueryParam(value="pageId") String var2, @QueryParam(value="search") String var3, @QueryParam(value="firstResult") Long var4, @QueryParam(value="maxResults") Long var5, @Context Request var6);

    @GET
    @Path(value="/{organizationId}/fragments")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations page fragments", notes="Lists organizations page fragments ", response=Fragment.class, responseContainer="List", tags={"Fragments"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of page fragments", response=Fragment.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Fragment.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Fragment.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Fragment.class, responseContainer="List")})
    public abstract Response listOrganizationFragments(@PathParam(value="organizationId") String var1, @QueryParam(value="slug") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/jobs")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations jobs", notes="Lists organizations jobs ", response=Job.class, responseContainer="List", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of organizations jobs", response=Job.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Job.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Job.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Job.class, responseContainer="List")})
    public abstract Response listOrganizationJobs(@PathParam(value="organizationId") String var1, @QueryParam(value="sortBy") String var2, @QueryParam(value="sortDir") String var3, @QueryParam(value="firstResult") Long var4, @QueryParam(value="maxResults") Long var5, @Context Request var6);

    @GET
    @Path(value="/{organizationId}/menus/{menuId}/items")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations menu items", notes="Lists organization menu items ", response=MenuItem.class, responseContainer="List", tags={"Menus"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of organizations menu items", response=MenuItem.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=MenuItem.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=MenuItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=MenuItem.class, responseContainer="List")})
    public abstract Response listOrganizationMenuItems(@PathParam(value="organizationId") String var1, @PathParam(value="menuId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/menus")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations menus", notes="Lists organizations menus ", response=Menu.class, responseContainer="List", tags={"Menus"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of organizations menus", response=Menu.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Menu.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Menu.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Menu.class, responseContainer="List")})
    public abstract Response listOrganizationMenus(@PathParam(value="organizationId") String var1, @QueryParam(value="slug") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/news")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations news", notes="Lists organizations news ", response=NewsArticle.class, responseContainer="List", tags={"News"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of news", response=NewsArticle.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=NewsArticle.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=NewsArticle.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=NewsArticle.class, responseContainer="List")})
    public abstract Response listOrganizationNews(@PathParam(value="organizationId") String var1, @QueryParam(value="slug") String var2, @QueryParam(value="publishedBefore") String var3, @QueryParam(value="publishedAfter") String var4, @QueryParam(value="firstResult") Integer var5, @QueryParam(value="maxResults") Integer var6, @Context Request var7);

    @GET
    @Path(value="/{organizationId}/news/{newsArticleId}/images")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns list of news article images", notes="Returns list of news article images ", response=Attachment.class, responseContainer="List", tags={"News"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a news article images", response=Attachment.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Attachment.class, responseContainer="List")})
    public abstract Response listOrganizationNewsArticleImages(@PathParam(value="organizationId") String var1, @PathParam(value="newsArticleId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/organizationServices")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Organization organization service list", notes="Lists organization's organization services", response=OrganizationService.class, responseContainer="List", tags={"Organizations", "OrganizationServices"})
    @ApiResponses(value={@ApiResponse(code=200, message="An array of organization services", response=OrganizationService.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=OrganizationService.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=OrganizationService.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=OrganizationService.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=OrganizationService.class, responseContainer="List")})
    public abstract Response listOrganizationOrganizationServices(@PathParam(value="organizationId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/pages/{pageId}/images")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns a list of organization page images", notes="Returns a list of organization page images ", response=Attachment.class, responseContainer="List", tags={"Pages"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns list of organization page images", response=Attachment.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Attachment.class, responseContainer="List")})
    public abstract Response listOrganizationPageImages(@PathParam(value="organizationId") String var1, @PathParam(value="pageId") String var2, @QueryParam(value="type") String var3, @Context Request var4);

    @GET
    @Path(value="/{organizationId}/pages")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations pages", notes="Lists organizations pages ", response=Page.class, responseContainer="List", tags={"Pages"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of pages", response=Page.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Page.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Page.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Page.class, responseContainer="List")})
    public abstract Response listOrganizationPages(@PathParam(value="organizationId") String var1, @QueryParam(value="parentId") String var2, @QueryParam(value="path") String var3, @QueryParam(value="search") String var4, @QueryParam(value="firstResult") Long var5, @QueryParam(value="maxResults") Long var6, @Context Request var7);

    @GET
    @Path(value="/{organizationId}/transportAgencies")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations public transport agencies", notes="Lists organizations public transport agencies ", response=Agency.class, responseContainer="List", tags={"Public transport"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of public transport agencies", response=Agency.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Agency.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Agency.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Agency.class, responseContainer="List")})
    public abstract Response listOrganizationPublicTransportAgencies(@PathParam(value="organizationId") String var1, @Context Request var2);

    @GET
    @Path(value="/{organizationId}/transportRoutes/{routeId}/stops")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists stops of organizations public transport route", notes="Lists stops of organizations public transport route ", response=Stop.class, responseContainer="List", tags={"Public transport"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of public transport routes stops", response=Stop.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Stop.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Stop.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Stop.class, responseContainer="List")})
    public abstract Response listOrganizationPublicTransportRouteStops(@PathParam(value="organizationId") String var1, @PathParam(value="routeId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/transportRoutes")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations public transport routes", notes="Lists organizations public transport routes ", response=Route.class, responseContainer="List", tags={"Public transport"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of public transport routes", response=Route.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Route.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Route.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Route.class, responseContainer="List")})
    public abstract Response listOrganizationPublicTransportRoutes(@PathParam(value="organizationId") String var1, @Context Request var2);

    @GET
    @Path(value="/{organizationId}/transportSchedules")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists schedules of organization's public transport schedules", notes="Lists schedules of organization's public transport schedules ", response=Schedule.class, responseContainer="List", tags={"Public transport"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of organization's public transport schedules", response=Schedule.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Schedule.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Schedule.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Schedule.class, responseContainer="List")})
    public abstract Response listOrganizationPublicTransportSchedules(@PathParam(value="organizationId") String var1, @Context Request var2);

    @GET
    @Path(value="/{organizationId}/settings/")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations settings", notes="Lists organizations settings ", response=OrganizationSetting.class, responseContainer="List", tags={"Settings"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of settings", response=OrganizationSetting.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=OrganizationSetting.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=OrganizationSetting.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=OrganizationSetting.class, responseContainer="List")})
    public abstract Response listOrganizationSettings(@PathParam(value="organizationId") String var1, @QueryParam(value="key") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/tiles/{tileId}/images")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Returns a list of organization tile images", notes="Returns a list of organization tile images ", response=Attachment.class, responseContainer="List", tags={"Tiles"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns list of organization tile images", response=Attachment.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Attachment.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Attachment.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Attachment.class, responseContainer="List")})
    public abstract Response listOrganizationTileImages(@PathParam(value="organizationId") String var1, @PathParam(value="tileId") String var2, @Context Request var3);

    @GET
    @Path(value="/{organizationId}/tiles")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists organizations tiles", notes="Lists organizations tiles ", response=Tile.class, responseContainer="List", tags={"Tiles"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a list of tiles", response=Tile.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Tile.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Tile.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Tile.class, responseContainer="List")})
    public abstract Response listOrganizationTiles(@PathParam(value="organizationId") String var1, @Context Request var2);

    @GET
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="List organizations", notes="List organizations", response=Organization.class, responseContainer="List", tags={"Organizations"})
    @ApiResponses(value={@ApiResponse(code=200, message="An array of organizations", response=Organization.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Organization.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Organization.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Organization.class, responseContainer="List")})
    public abstract Response listOrganizations(@QueryParam(value="businessName") String var1, @QueryParam(value="businessCode") String var2, @QueryParam(value="search") String var3, @QueryParam(value="firstResult") Long var4, @QueryParam(value="maxResults") Long var5, @Context Request var6);

    @PUT
    @Path(value="/{organizationId}/organizationServices/{organizationServiceId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates an organization service", notes="Updates organization service", response=OrganizationService.class, tags={"Organizations", "OrganizationServices"})
    @ApiResponses(value={@ApiResponse(code=200, message="An updated organization service", response=OrganizationService.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=OrganizationService.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=OrganizationService.class), @ApiResponse(code=404, message="Resource was not found from the server", response=OrganizationService.class), @ApiResponse(code=500, message="Internal server error", response=OrganizationService.class)})
    public abstract Response updateOrganizationService(@PathParam(value="organizationId") String var1, @PathParam(value="organizationServiceId") String var2, OrganizationService var3, @Context Request var4);

    @PUT
    @Path(value="/{organizationId}/settings/{settingId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates an organization setting", notes="Updates an organization setting ", response=OrganizationSetting.class, tags={"Settings"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a single an updated organization setting", response=OrganizationSetting.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=OrganizationSetting.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=OrganizationSetting.class), @ApiResponse(code=500, message="Internal server error", response=OrganizationSetting.class)})
    public abstract Response updateOrganizationSetting(@PathParam(value="organizationId") String var1, @PathParam(value="settingId") String var2, OrganizationSetting var3, @Context Request var4);
}

