/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import fi.metatavu.kuntaapi.server.rest.model.Municipality;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Area")
public class Area
implements Serializable {
    private String type = null;
    private String code = null;
    private List<LocalizedValue> name = new ArrayList<LocalizedValue>();
    private List<Municipality> municipalities = new ArrayList<Municipality>();

    public Area type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the area (Municipality, Province, BusinessRegions, HospitalRegions).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Area code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(example="null", value="Code of the area.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Area name(List<LocalizedValue> name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Localized list of names for the area")
    public List<LocalizedValue> getName() {
        return this.name;
    }

    public void setName(List<LocalizedValue> name) {
        this.name = name;
    }

    public Area municipalities(List<Municipality> municipalities) {
        this.municipalities = municipalities;
        return this;
    }

    @ApiModelProperty(example="null", value="List of municipalities including municipality code and a localized list of municipality names.")
    public List<Municipality> getMunicipalities() {
        return this.municipalities;
    }

    public void setMunicipalities(List<Municipality> municipalities) {
        this.municipalities = municipalities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Area area = (Area)o;
        return Objects.equals(this.type, area.type) && Objects.equals(this.code, area.code) && Objects.equals(this.name, area.name) && Objects.equals(this.municipalities, area.municipalities);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.code, this.name, this.municipalities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Area {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    municipalities: ").append(this.toIndentedString(this.municipalities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

