/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import fi.metatavu.kuntaapi.server.rest.model.WebPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Service organization")
public class ServiceOrganization {
    private List<LocalizedValue> additionalInformation = new ArrayList<LocalizedValue>();
    private String organizationId = null;
    private String roleType = null;
    private String provisionType = null;
    private List<WebPage> webPages = new ArrayList<WebPage>();

    public ServiceOrganization additionalInformation(List<LocalizedValue> additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="Localized list of additional information.")
    public List<LocalizedValue> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(List<LocalizedValue> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public ServiceOrganization organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization identifier (organization related to the service). Required if role type is Responsible or if ProvisionType is SelfProduced.")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public ServiceOrganization roleType(String roleType) {
        this.roleType = roleType;
        return this;
    }

    @ApiModelProperty(example="null", value="Role type, valid values Responsible or Producer.")
    public String getRoleType() {
        return this.roleType;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public ServiceOrganization provisionType(String provisionType) {
        this.provisionType = provisionType;
        return this;
    }

    @ApiModelProperty(example="null", value="Provision type, valid values SelfProduced, VoucherServices, PurchaseServices or Other. Required if RoleType value is Producer.")
    public String getProvisionType() {
        return this.provisionType;
    }

    public void setProvisionType(String provisionType) {
        this.provisionType = provisionType;
    }

    public ServiceOrganization webPages(List<WebPage> webPages) {
        this.webPages = webPages;
        return this;
    }

    @ApiModelProperty(example="null", value="DEPRECATED. DO NOT USE")
    public List<WebPage> getWebPages() {
        return this.webPages;
    }

    public void setWebPages(List<WebPage> webPages) {
        this.webPages = webPages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceOrganization serviceOrganization = (ServiceOrganization)o;
        return Objects.equals(this.additionalInformation, serviceOrganization.additionalInformation) && Objects.equals(this.organizationId, serviceOrganization.organizationId) && Objects.equals(this.roleType, serviceOrganization.roleType) && Objects.equals(this.provisionType, serviceOrganization.provisionType) && Objects.equals(this.webPages, serviceOrganization.webPages);
    }

    public int hashCode() {
        return Objects.hash(this.additionalInformation, this.organizationId, this.roleType, this.provisionType, this.webPages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceOrganization {\n");
        sb.append("    additionalInformation: ").append(this.toIndentedString(this.additionalInformation)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    roleType: ").append(this.toIndentedString(this.roleType)).append("\n");
        sb.append("    provisionType: ").append(this.toIndentedString(this.provisionType)).append("\n");
        sb.append("    webPages: ").append(this.toIndentedString(this.webPages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

