/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.Email;
import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import fi.metatavu.kuntaapi.server.rest.model.Phone;
import fi.metatavu.kuntaapi.server.rest.model.ServiceHour;
import fi.metatavu.kuntaapi.server.rest.model.WebPage;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PhoneServiceChannel {
    private String id = null;
    private String organizationId = null;
    private List<LocalizedValue> names = new ArrayList<LocalizedValue>();
    private List<LocalizedValue> descriptions = new ArrayList<LocalizedValue>();
    private List<Phone> phoneNumbers = new ArrayList<Phone>();
    private List<Email> supportEmails = new ArrayList<Email>();
    private List<String> languages = new ArrayList<String>();
    private List<WebPage> webPages = new ArrayList<WebPage>();
    private List<ServiceHour> serviceHours = new ArrayList<ServiceHour>();
    private String publishingStatus = null;

    public PhoneServiceChannel id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifier for the service channel.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PhoneServiceChannel organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization identifier responsible for the channel.")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public PhoneServiceChannel names(List<LocalizedValue> names) {
        this.names = names;
        return this;
    }

    @ApiModelProperty(example="null", value="Localized list of service channel names.")
    public List<LocalizedValue> getNames() {
        return this.names;
    }

    public void setNames(List<LocalizedValue> names) {
        this.names = names;
    }

    public PhoneServiceChannel descriptions(List<LocalizedValue> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of localized service channel descriptions.")
    public List<LocalizedValue> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<LocalizedValue> descriptions) {
        this.descriptions = descriptions;
    }

    public PhoneServiceChannel phoneNumbers(List<Phone> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="List of phone numbers for the service channel.")
    public List<Phone> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<Phone> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public PhoneServiceChannel supportEmails(List<Email> supportEmails) {
        this.supportEmails = supportEmails;
        return this;
    }

    @ApiModelProperty(example="null", value="List of support email addresses for the service channel.")
    public List<Email> getSupportEmails() {
        return this.supportEmails;
    }

    public void setSupportEmails(List<Email> supportEmails) {
        this.supportEmails = supportEmails;
    }

    public PhoneServiceChannel languages(List<String> languages) {
        this.languages = languages;
        return this;
    }

    @ApiModelProperty(example="null", value="List of languages the service channel is available in (two letter language code).")
    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public PhoneServiceChannel webPages(List<WebPage> webPages) {
        this.webPages = webPages;
        return this;
    }

    @ApiModelProperty(example="null", value="List of service channel web pages.")
    public List<WebPage> getWebPages() {
        return this.webPages;
    }

    public void setWebPages(List<WebPage> webPages) {
        this.webPages = webPages;
    }

    public PhoneServiceChannel serviceHours(List<ServiceHour> serviceHours) {
        this.serviceHours = serviceHours;
        return this;
    }

    @ApiModelProperty(example="null", value="List of service channel service hours.")
    public List<ServiceHour> getServiceHours() {
        return this.serviceHours;
    }

    public void setServiceHours(List<ServiceHour> serviceHours) {
        this.serviceHours = serviceHours;
    }

    public PhoneServiceChannel publishingStatus(String publishingStatus) {
        this.publishingStatus = publishingStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Service channel publishing status. Values: Draft, Published, Deleted, Modified or OldPublished.")
    public String getPublishingStatus() {
        return this.publishingStatus;
    }

    public void setPublishingStatus(String publishingStatus) {
        this.publishingStatus = publishingStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneServiceChannel phoneServiceChannel = (PhoneServiceChannel)o;
        return Objects.equals(this.id, phoneServiceChannel.id) && Objects.equals(this.organizationId, phoneServiceChannel.organizationId) && Objects.equals(this.names, phoneServiceChannel.names) && Objects.equals(this.descriptions, phoneServiceChannel.descriptions) && Objects.equals(this.phoneNumbers, phoneServiceChannel.phoneNumbers) && Objects.equals(this.supportEmails, phoneServiceChannel.supportEmails) && Objects.equals(this.languages, phoneServiceChannel.languages) && Objects.equals(this.webPages, phoneServiceChannel.webPages) && Objects.equals(this.serviceHours, phoneServiceChannel.serviceHours) && Objects.equals(this.publishingStatus, phoneServiceChannel.publishingStatus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.organizationId, this.names, this.descriptions, this.phoneNumbers, this.supportEmails, this.languages, this.webPages, this.serviceHours, this.publishingStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneServiceChannel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    supportEmails: ").append(this.toIndentedString(this.supportEmails)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    webPages: ").append(this.toIndentedString(this.webPages)).append("\n");
        sb.append("    serviceHours: ").append(this.toIndentedString(this.serviceHours)).append("\n");
        sb.append("    publishingStatus: ").append(this.toIndentedString(this.publishingStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

