/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.CodeExtra;
import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Generic code item describing code / name pair (e.g. LanguageCode, MunicipalityCode, etc...)")
public class Code {
    private String type = null;
    private String code = null;
    private List<LocalizedValue> names = new ArrayList<LocalizedValue>();
    private List<CodeExtra> extra = new ArrayList<CodeExtra>();

    public Code type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the code. Value must be one of MUNICIPALITY, PROVINCE, HOSPITALREGIONS, BUSINESSREGIONS, COUNTRY, LANGUAGE, POSTAL")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Code code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(example="null", value="Code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Code names(List<LocalizedValue> names) {
        this.names = names;
        return this;
    }

    @ApiModelProperty(example="null", value="Names")
    public List<LocalizedValue> getNames() {
        return this.names;
    }

    public void setNames(List<LocalizedValue> names) {
        this.names = names;
    }

    public Code extra(List<CodeExtra> extra) {
        this.extra = extra;
        return this;
    }

    @ApiModelProperty(example="null", value="Names")
    public List<CodeExtra> getExtra() {
        return this.extra;
    }

    public void setExtra(List<CodeExtra> extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Code code = (Code)o;
        return Objects.equals(this.type, code.type) && Objects.equals(code, code.code) && Objects.equals(this.names, code.names) && Objects.equals(this.extra, code.extra);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.code, this.names, this.extra);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Code {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

