/*
 * Decompiled with CFR 0.152.
 */
package eu.maxschuster.dataurl;

public enum DataUrlEncoding {
    BASE64("base64"),
    URL("");

    private final String encodingName;

    private DataUrlEncoding(String encodingName) {
        this.encodingName = encodingName;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public static final DataUrlEncoding valueOfEncodingName(String encodingName) throws IllegalArgumentException, NullPointerException {
        if (encodingName == null) {
            throw new NullPointerException("encodingName must not be null!");
        }
        for (DataUrlEncoding value : DataUrlEncoding.values()) {
            String name = value.getEncodingName();
            if (!name.equals(encodingName)) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }
}

