/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.Locale;

public final class DateUtil {
    private DateUtil() {
    }

    public static Date toDate(LocalDate input) {
        return DateUtil.toDate(input, ZoneId.systemDefault());
    }

    public static Date toDate(LocalDate input, ZoneId zone) {
        if (input == null) {
            return null;
        }
        if (zone == null) {
            return null;
        }
        return Date.from(input.atStartOfDay(zone).toInstant());
    }

    public static Date toDate(LocalDateTime input) {
        return DateUtil.toDate(input, ZoneId.systemDefault());
    }

    public static Date toDate(LocalDateTime input, ZoneId zone) {
        if (input == null) {
            return null;
        }
        if (zone == null) {
            return null;
        }
        return Date.from(input.atZone(zone).toInstant());
    }

    public static Date toDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    public static LocalDateTime toLocalDateTime(Date input) {
        return DateUtil.toLocalDateTime(input, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Date input, ZoneId zone) {
        if (input == null) {
            return null;
        }
        if (zone == null) {
            return null;
        }
        return LocalDateTime.ofInstant(input.toInstant(), zone);
    }

    public static LocalDateTime toLocalDateTime(long epochMiliseconds) {
        return Instant.ofEpochMilli(epochMiliseconds).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate toLocalDate(Date input) {
        if (input == null) {
            return null;
        }
        LocalDateTime localDateTime = DateUtil.toLocalDateTime(input, ZoneId.systemDefault());
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.toLocalDate();
    }

    public static LocalDate toLocalDate(Date input, ZoneId zone) {
        if (input == null) {
            return null;
        }
        if (zone == null) {
            return null;
        }
        return DateUtil.toLocalDateTime(input, zone).toLocalDate();
    }

    public static Timestamp toTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static LocalDate toLocalDate(long epochMiliseconds) {
        return Instant.ofEpochMilli(epochMiliseconds).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Instant toInstant(LocalDate input) {
        return DateUtil.toInstant(input, ZoneId.systemDefault());
    }

    public static Instant toInstant(LocalDate input, ZoneId zone) {
        return input.atStartOfDay(zone).toInstant();
    }

    public static Instant toInstant(LocalDateTime input) {
        return DateUtil.toInstant(input, ZoneId.systemDefault());
    }

    public static Instant toInstant(LocalDateTime input, ZoneId zone) {
        return input.atZone(zone).toInstant();
    }

    public static Instant toInstant(Date input) {
        return input.toInstant();
    }

    public static LocalDateTime endOfDay() {
        return DateUtil.endOfDay(LocalDate.now());
    }

    public static LocalDateTime endOfDay(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.plusDays(1L).atStartOfDay().minusNanos(1L);
    }

    public static LocalDate beginOfWeek(Locale locale) {
        return DateUtil.beginOfWeek(LocalDate.now(), locale);
    }

    public static LocalDate beginOfWeek(LocalDate date, Locale locale) {
        if (date == null) {
            return null;
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null.");
        }
        TemporalField weekField = WeekFields.of(locale).dayOfWeek();
        return date.with(weekField, 1L);
    }

    public static LocalDate endOfWeek(Locale locale) {
        return DateUtil.endOfWeek(LocalDate.now(), locale);
    }

    public static LocalDate endOfWeek(LocalDate date, Locale locale) {
        if (date == null) {
            return null;
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null.");
        }
        TemporalField weekField = WeekFields.of(locale).dayOfWeek();
        return date.with(weekField, 7L);
    }

    public static LocalDate beginOfMonth() {
        return DateUtil.beginOfMonth(LocalDate.now());
    }

    public static LocalDate beginOfMonth(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.withDayOfMonth(1);
    }

    public static LocalDate endOfMonth() {
        return DateUtil.endOfMonth(LocalDate.now());
    }

    public static LocalDate endOfMonth(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.withDayOfMonth(1).plusMonths(1L).minusDays(1L);
    }

    public static LocalDate beginOfYear() {
        return DateUtil.beginOfYear(LocalDate.now());
    }

    public static LocalDate beginOfYear(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.withDayOfYear(1);
    }

    public static LocalDate endOfYear() {
        return DateUtil.endOfYear(LocalDate.now());
    }

    public static LocalDate endOfYear(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.withDayOfYear(1).plusYears(1L).minusDays(1L);
    }
}

