/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import eu.lundegaard.commons.util.ValidateUtil;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class CaseUtil {
    private CaseUtil() {
    }

    public static String[] fromCamelCase(String input) {
        ValidateUtil.validateNotNull(input);
        return input.split("(?<!^)(?=[A-Z])");
    }

    public static String[] fromUpperCamelCase(String input) {
        return CaseUtil.fromCamelCase(input);
    }

    public static String[] fromLowerCamelCase(String input) {
        return CaseUtil.fromCamelCase(input);
    }

    public static String[] fromKebabCase(String input) {
        ValidateUtil.validateNotNull(input);
        return input.split("-");
    }

    public static String[] fromUpperCase(String input) {
        return CaseUtil.fromLowerCase(input);
    }

    public static String[] fromLowerCase(String input) {
        ValidateUtil.validateNotNull(input);
        return input.split(" ");
    }

    public static String[] fromConstantCase(String input) {
        return CaseUtil.fromSnakeCase(input);
    }

    public static String[] fromSnakeCase(String input) {
        ValidateUtil.validateNotNull(input);
        return input.split("_");
    }

    public static String toCamelCase(String[] words) {
        return CaseUtil.toLowerCamelCase(words);
    }

    public static String toUpperCamelCase(String[] words) {
        ValidateUtil.validateNotNull(words);
        return CaseUtil.format(words, "", false, true, true);
    }

    public static String toLowerCamelCase(String[] words) {
        ValidateUtil.validateNotNull(words);
        return CaseUtil.format(words, "", false, true, false);
    }

    public static String toKebabCase(String[] words) {
        ValidateUtil.validateNotNull(words);
        return CaseUtil.format(words, "-", false);
    }

    public static String toUpperCase(String[] words) {
        ValidateUtil.validateNotNull(words);
        return CaseUtil.format(words, " ", true);
    }

    public static String toLowerCase(String[] words) {
        ValidateUtil.validateNotNull(words);
        return CaseUtil.format(words, " ", false);
    }

    public static String toConstantCase(String[] words) {
        ValidateUtil.validateNotNull(words);
        return CaseUtil.format(words, "_", true);
    }

    public static String toSnakeCase(String[] words) {
        ValidateUtil.validateNotNull(words);
        return CaseUtil.format(words, "_", false);
    }

    private static String format(String[] words, String separator, boolean capitalized) {
        return CaseUtil.format(words, separator, capitalized, capitalized, capitalized);
    }

    private static String format(String[] words, String separator, boolean capitalizedLetters, boolean capitalizedWords, boolean capitalizedPhrase) {
        ValidateUtil.validateNotEmpty(words);
        ValidateUtil.validateNotNull(separator);
        String phrase = Arrays.stream(words).filter(word -> !word.isEmpty()).map(word -> CaseUtil.formatWordCase(word, capitalizedLetters, capitalizedWords)).collect(Collectors.joining(separator));
        if (capitalizedPhrase != capitalizedWords) {
            phrase = CaseUtil.formatFirstLetterCase(phrase, capitalizedPhrase);
        }
        return phrase;
    }

    private static String formatWordCase(String input, boolean allLettersCapital, boolean firstLetterCapital) {
        ValidateUtil.validateNotNull(input);
        if (input.isEmpty()) {
            return input;
        }
        if (input.length() == 1) {
            return CaseUtil.formatStringCase(input, firstLetterCapital);
        }
        String result = CaseUtil.formatStringCase(input, allLettersCapital);
        if (allLettersCapital != firstLetterCapital) {
            result = CaseUtil.formatFirstLetterCase(result, firstLetterCapital);
        }
        return result;
    }

    private static String formatStringCase(String input, boolean toUpperCase) {
        ValidateUtil.validateNotNull(input);
        return toUpperCase ? input.toUpperCase() : input.toLowerCase();
    }

    private static String formatFirstLetterCase(String input, boolean toUpperCase) {
        ValidateUtil.validateNotNull(input);
        if (input.isEmpty()) {
            return input;
        }
        if (input.length() == 1) {
            return CaseUtil.formatStringCase(input, toUpperCase);
        }
        String firstLetter = input.substring(0, 1);
        String otherLetters = input.substring(1);
        return CaseUtil.formatStringCase(firstLetter, toUpperCase) + otherLetters;
    }
}

