/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.tuple;

import java.util.Objects;

public class Pair<T, U> {
    private final T first;
    private final U second;

    public Pair(T first, U second) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("Values of the pair must not be null.");
        }
        this.first = first;
        this.second = second;
    }

    public T getFirst() {
        return this.first;
    }

    public Pair<T, U> withFirst(T newFirst) {
        return new Pair<T, U>(newFirst, this.second);
    }

    public U getSecond() {
        return this.second;
    }

    public Pair<T, U> withSecond(U newSecond) {
        return new Pair<T, U>(this.first, newSecond);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (!this.first.equals(pair.first)) {
            return false;
        }
        return this.second.equals(pair.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.first + "," + this.second + "}";
    }
}

