/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Maps {
    private Maps() {
    }

    public static <K, V> MapBuilder<K, V> of(K firstKey, V firstValue) {
        return new MapBuilder<K, V>(new HashMap()).put(firstKey, firstValue);
    }

    public static <K, V> MapBuilder<K, V> with(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static class MapBuilder<K, V> {
        private final Map<K, V> map;

        public MapBuilder(Map<K, V> map) {
            this.map = map;
        }

        public MapBuilder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public Map<K, V> build() {
            return this.map;
        }

        public Map<K, V> buildUnmodifiable() {
            return Collections.unmodifiableMap(this.map);
        }

        public Map<K, V> buildSynchronized() {
            return Collections.synchronizedMap(this.map);
        }
    }
}

