/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.lundegaard.commons.exception.ApplicationException;
import eu.lundegaard.commons.jackson.ObjectMapperFactory;
import eu.lundegaard.commons.util.ValidateUtil;
import java.io.IOException;

public final class SerializingUtil {
    private static final ObjectMapper MAPPER = ObjectMapperFactory.createObjectMapper();

    private SerializingUtil() {
    }

    public static String serializeToJson(Object entity) {
        try {
            return MAPPER.writeValueAsString(entity);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Cannot convert object to JSON.", e);
        }
    }

    public static <T> T deserializeFromJson(String json, Class<T> objectClass) {
        ValidateUtil.validateNotNull((Object)json);
        try {
            return (T)MAPPER.readValue(json, objectClass);
        }
        catch (IOException e) {
            throw new SerializationException("Cannot convert JSON string into class: " + objectClass.getName(), e);
        }
    }

    public static class SerializationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public SerializationException(String message, Throwable cause) {
            super(message, cause);
        }

        public SerializationException(String message) {
            super(message);
        }
    }
}

