/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.redsysonandroid.library;

import android.support.annotation.NonNull;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import sis.redsys.api.ApiMacSha256;

public class RedsysPayment {
    float amount;
    int currency;
    int transactionType;
    int terminal;
    long orderNumber;
    String successUrl;
    String failureUrl;
    String merchantUrl;
    String secretKey;
    String merchantId;
    String signatureType;

    public int getCurrency() {
        return this.currency;
    }

    public void setCurrency(int currency) {
        this.currency = currency;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public String getMerchantUrl() {
        return this.merchantUrl;
    }

    public void setMerchantUrl(String merchantUrl) {
        this.merchantUrl = merchantUrl;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public long getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(long orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(int transactionType) {
        this.transactionType = transactionType;
    }

    public int getTerminal() {
        return this.terminal;
    }

    public void setTerminal(int terminal) {
        this.terminal = terminal;
    }

    public void setSignatureType(@NonNull String signatureType) {
        this.signatureType = signatureType;
    }

    private ApiMacSha256 getEncryptionObject() {
        ApiMacSha256 apiMacSha256 = new ApiMacSha256();
        apiMacSha256.setParameter("DS_MERCHANT_AMOUNT", Float.toString(this.getAmount()));
        apiMacSha256.setParameter("DS_MERCHANT_ORDER", Long.toString(this.orderNumber));
        apiMacSha256.setParameter("DS_MERCHANT_MERCHANTCODE", this.getMerchantId());
        apiMacSha256.setParameter("DS_MERCHANT_CURRENCY", Integer.toString(this.getCurrency()));
        apiMacSha256.setParameter("DS_MERCHANT_TRANSACTIONTYPE", Integer.toString(this.transactionType));
        apiMacSha256.setParameter("DS_MERCHANT_TERMINAL", Integer.toString(this.terminal));
        apiMacSha256.setParameter("DS_MERCHANT_MERCHANTURL", this.getMerchantUrl());
        apiMacSha256.setParameter("DS_MERCHANT_URLOK", this.getSuccessUrl());
        apiMacSha256.setParameter("DS_MERCHANT_URLKO", this.getFailureUrl());
        return apiMacSha256;
    }

    public String createMerchantParameters() throws UnsupportedEncodingException {
        return this.getEncryptionObject().createMerchantParameters();
    }

    public String createMerchantSignature() throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.getEncryptionObject().createMerchantSignature(this.secretKey);
    }

    public String getSignatureType() {
        return this.signatureType;
    }

    public static class Builder {
        private int currency = 978;
        private int transactionType = 0;
        private int terminal = 1;
        private float amount = 0.0f;
        private long orderNumber = 0L;
        private String signatureType = "HMAC_SHA256_V1";
        private String successUrl = "";
        private String failureUrl = "";
        private String merchantUrl = "";
        private String secretKey = "";
        private String merchantId = "";

        public Builder setAmount(float amount) {
            this.amount = amount;
            return this;
        }

        public Builder setCurrency(int currency) {
            this.currency = currency;
            return this;
        }

        public Builder setOrderNumber(long orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        public Builder setSuccessUrl(@NonNull String successUrl) {
            this.successUrl = successUrl;
            return this;
        }

        public Builder setFailureUrl(@NonNull String failureUrl) {
            this.failureUrl = failureUrl;
            return this;
        }

        public Builder setMerchantUrl(@NonNull String merchantUrl) {
            this.merchantUrl = merchantUrl;
            return this;
        }

        public Builder setSecretKey(@NonNull String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder setMerchantId(@NonNull String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder setTransactionType(int transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public Builder setTerminal(int terminal) {
            this.terminal = terminal;
            return this;
        }

        public Builder setSignatureType(@NonNull String signatureType) {
            this.signatureType = signatureType;
            return this;
        }

        public RedsysPayment create() {
            RedsysPayment payment = new RedsysPayment();
            payment.setAmount(this.amount);
            payment.setCurrency(this.currency);
            payment.setOrderNumber(this.orderNumber);
            payment.setSuccessUrl(this.successUrl);
            payment.setFailureUrl(this.failureUrl);
            payment.setMerchantUrl(this.merchantUrl);
            payment.setSecretKey(this.secretKey);
            payment.setMerchantId(this.merchantId);
            payment.setTransactionType(this.transactionType);
            payment.setTerminal(this.terminal);
            payment.setSignatureType(this.signatureType);
            return payment;
        }
    }
}

