/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.redsysonandroid.library;

import android.content.Context;
import android.support.annotation.NonNull;
import es.voghdev.redsysonandroid.library.RedsysHtmlForm;
import es.voghdev.redsysonandroid.library.RedsysPayment;
import java.io.InputStream;

public class RedsysHtmlFormAssetImpl
implements RedsysHtmlForm {
    Context context;
    String assetName;
    boolean useTestUrl = false;

    public RedsysHtmlFormAssetImpl(@NonNull Context context, @NonNull String assetName) {
        this.context = context;
        this.assetName = assetName;
    }

    public RedsysHtmlFormAssetImpl(Context context, String assetName, boolean useTestURL) {
        this.context = context;
        this.assetName = assetName;
        this.useTestUrl = useTestURL;
    }

    @Override
    public String generateHtml(RedsysPayment payment) {
        try {
            InputStream inputStream = this.context.getAssets().open(this.assetName);
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            inputStream.close();
            String html = new String(buffer);
            html = html.replace("_redsys_merchantParameters_", payment.createMerchantParameters()).replace("_redsys_signature_", payment.createMerchantSignature()).replace("_redsys_signatureVersion_", payment.getSignatureType()).replace("_redsys_actionUrl_", this.useTestUrl ? "https://sis-t.redsys.es:25443/sis/realizarPago/" : "https://sis.redsys.es/sis/realizarPago/");
            return html;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

