/*
 * Copyright (C) 2017 Olmo Gallegos Hernández.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package es.voghdev.redsysonandroid.library;

import android.content.Context;
import android.support.annotation.NonNull;

import java.io.InputStream;

public class RedsysHtmlFormAssetImpl implements RedsysHtmlForm {
    Context context;
    String assetName;
    boolean useTestUrl = false;

    public RedsysHtmlFormAssetImpl(@NonNull Context context, @NonNull String assetName) {
        this.context = context;
        this.assetName = assetName;
    }

    public RedsysHtmlFormAssetImpl(Context context, String assetName, boolean useTestURL) {
        this.context = context;
        this.assetName = assetName;
        this.useTestUrl = useTestURL;
    }

    @Override
    public String generateHtml(RedsysPayment payment) {
        try {
            InputStream inputStream = context.getAssets().open(assetName);
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            inputStream.close();

            String html = new String(buffer);
            html = html.replace("_redsys_merchantParameters_", payment.createMerchantParameters())
                    .replace("_redsys_signature_", payment.createMerchantSignature())
                    .replace("_redsys_signatureVersion_", payment.getSignatureType())
                    .replace("_redsys_actionUrl_", useTestUrl ? Redsys.TEST_URL : Redsys.PROD_URL);

            return html;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return "";
    }
}
