/*
 * Decompiled with CFR 0.152.
 */
package dk.hyperdivision.multisig_hmac;

import dk.hyperdivision.multisig_hmac.Combine;
import dk.hyperdivision.multisig_hmac.DeriveKey;
import dk.hyperdivision.multisig_hmac.Sign;
import dk.hyperdivision.multisig_hmac.Verify;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

public class VerifyDerived {
    public static boolean verifyderived(byte[] MasterSeed, Combine Signature, byte[] data, int Threshold, String Algorithm2, int KEYBYTES, int BYTES) throws InvalidKeyException, NoSuchAlgorithmException {
        assert (MasterSeed.length == KEYBYTES) : "MasterSeed must be KEYBYTES long";
        assert (Signature.sig.length == BYTES) : "Signature must be BYTES long";
        assert (Threshold > 0) : "Threshold must be at least 1";
        int BitField = Signature.bitfield;
        int nKeys = Verify.PopCount(BitField);
        if (nKeys < Threshold) {
            return false;
        }
        List<Integer> UsedKeys = Verify.keyIndexes(BitField);
        byte[] Sig = Signature.sig;
        for (Integer usedKey : UsedKeys) {
            DeriveKey Key2 = new DeriveKey(MasterSeed, usedKey, Algorithm2);
            Sign KeySig = new Sign(Key2, data, Algorithm2);
            Sig = Combine.xorBytes(Sig, KeySig.sign, BYTES);
            BitField ^= KeySig.index;
        }
        return BitField == 0 && Arrays.equals(Sig, new byte[BYTES]);
    }
}

