/*
 * Decompiled with CFR 0.152.
 */
package dk.hyperdivision.multisig_hmac;

import dk.hyperdivision.multisig_hmac.Combine;
import dk.hyperdivision.multisig_hmac.IndexKey;
import dk.hyperdivision.multisig_hmac.Sign;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Verify {
    public static boolean verify(List<IndexKey> Keys, Combine Signature, byte[] data, int Threshold, String Algorithm2, int BYTES) throws InvalidKeyException, NoSuchAlgorithmException {
        assert (Signature.sig.length == BYTES) : "Signature must be BYTES long";
        assert (data != null) : "data must be bytes";
        assert (Threshold > 0) : "Threshold must be at least 1";
        int BitField = Signature.bitfield;
        int nKeys = Verify.PopCount(BitField);
        int HighestKey = 32 - Verify.LeadingZeros(BitField);
        assert (Keys.size() >= nKeys && Keys.size() >= HighestKey) : "Not enough keys given based on Signature.bitfield";
        if (nKeys < Threshold) {
            return false;
        }
        List<Integer> UsedKeys = Verify.keyIndexes(BitField);
        byte[] Sig = Signature.sig;
        for (Integer obj : UsedKeys) {
            IndexKey Key = Keys.get(obj);
            Sign KeySig = new Sign(Key, data, Algorithm2);
            Sig = Combine.xorBytes(Sig, KeySig.sign, BYTES);
            BitField ^= KeySig.index;
        }
        return BitField == 0 && Arrays.equals(Sig, new byte[BYTES]);
    }

    public static List<Integer> keyIndexes(int BitField) {
        ArrayList<Integer> KeyIndexes = new ArrayList<Integer>();
        int i = 0;
        while (BitField > 0) {
            if ((BitField & 1) == 1) {
                KeyIndexes.add(i);
            }
            BitField >>= 1;
            ++i;
        }
        return KeyIndexes;
    }

    public static int PopCount(int BitField) {
        return Integer.bitCount(BitField);
    }

    public static int LeadingZeros(int BitField) {
        int n = 32;
        for (int c = 16; c != 0; c >>= 1) {
            int y = BitField >> c;
            if (y == 0) continue;
            n -= c;
            BitField = y;
        }
        return n - BitField;
    }
}

