/*
 * Decompiled with CFR 0.152.
 */
package dk.hyperdivision.multisig_hmac;

import dk.hyperdivision.multisig_hmac.IndexKey;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DeriveKey
extends IndexKey {
    public DeriveKey(byte[] MasterSeed, int index, String Algorithm2) throws InvalidKeyException, NoSuchAlgorithmException {
        this.index = index;
        this.key = DeriveKey.derivekey(MasterSeed, index, Algorithm2);
    }

    public static byte[] derivekey(byte[] MasterSeed, int index, String Algorithm2) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] DataBytes = "derived".getBytes();
        byte[] IndexArray = DeriveKey.intToLittleEndian(index);
        byte[] _scratch = ByteBuffer.allocate(DataBytes.length + IndexArray.length).put(DataBytes).put(IndexArray).array();
        byte[] ZERO = new byte[]{0};
        byte[] ONE = new byte[]{1};
        Mac HMAC0 = Mac.getInstance(Algorithm2);
        SecretKeySpec Key2 = new SecretKeySpec(MasterSeed, Algorithm2);
        HMAC0.init(Key2);
        HMAC0.update(_scratch);
        byte[] h0 = HMAC0.doFinal(ZERO);
        Mac HMAC1 = Mac.getInstance(Algorithm2);
        HMAC1.init(Key2);
        HMAC1.update(h0);
        byte[] h1 = HMAC1.doFinal(ONE);
        return ByteBuffer.allocate(h0.length + h1.length).put(h0).put(h1).array();
    }

    public static byte[] SeedGen(int KEYBYTES) {
        byte[] SeedGen = new byte[KEYBYTES];
        SecureRandom random = new SecureRandom();
        random.nextBytes(SeedGen);
        return SeedGen;
    }

    public static byte[] intToLittleEndian(int index) {
        byte[] b = new byte[]{(byte)(index & 0xFF), (byte)(index >> 8 & 0xFF), (byte)(index >> 16 & 0xFF), (byte)(index >> 24 & 0xFF)};
        return b;
    }
}

