/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.sam;

import java.util.HashMap;
import java.util.Hashtable;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.kerberos.sam.KeyIntegrityChecker;
import org.apache.kerberos.sam.SamException;
import org.apache.kerberos.sam.SamVerifier;
import org.apache.kerberos.store.PrincipalStoreEntry;

public final class SamSubsystem {
    public static final String PROPKEY_BASE = "kerberos.sam.type.";
    private static final HashMap verifiers = new HashMap();
    private static final Hashtable env = new Hashtable();
    private static KeyIntegrityChecker keyChecker;

    public static void setIntegrityChecker(KeyIntegrityChecker keyChecker) {
        SamSubsystem.keyChecker = keyChecker;
    }

    public static KerberosKey verify(PrincipalStoreEntry entry, byte[] sad) throws SamException {
        SamVerifier verifier = null;
        if (keyChecker == null) {
            throw new IllegalStateException("SamSubsystem not enabled with key integrity checker");
        }
        if (entry.getSamType() == null) {
            throw new SamException(entry.getSamType(), "Entry has null SAM type");
        }
        if (verifiers.containsKey(entry.getSamType())) {
            verifier = (SamVerifier)verifiers.get(entry.getSamType());
            return verifier.verify(entry.getPrincipal(), sad);
        }
        String key = PROPKEY_BASE + entry.getSamType().getOrdinal();
        if (!env.containsKey(key)) {
            String msg = "Could not find property '" + key + "'";
            throw new SamException(entry.getSamType(), msg);
        }
        String fqcn = (String)env.get(key);
        try {
            Class<?> c = Class.forName(fqcn);
            verifier = (SamVerifier)c.newInstance();
            verifier.setIntegrityChecker(keyChecker);
            if (!verifier.getSamType().equals(entry.getSamType())) {
                String msg = "Expecting entries with SAM type of " + verifier.getSamType();
                msg = msg + " but got a type of entry with SAM type of " + entry.getSamType();
                throw new SamException(entry.getSamType(), msg);
            }
            verifiers.put(verifier.getSamType(), verifier);
            return verifier.verify(entry.getPrincipal(), sad);
        }
        catch (ClassNotFoundException e) {
            String msg = "Could not find verifier class '" + fqcn;
            msg = msg + "' for SamType( " + entry.getSamType() + " ) ";
            throw new SamException(entry.getSamType(), msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "No public default constructor on class '" + fqcn;
            msg = msg + "' for SamType( " + entry.getSamType() + " ) ";
            throw new SamException(entry.getSamType(), msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Failed on default constructor invocation for class '" + fqcn;
            msg = msg + "' for SamType( " + entry.getSamType() + " ) ";
            throw new SamException(entry.getSamType(), msg, e);
        }
    }

    public static void setEnvironment(Hashtable properties) {
        env.putAll(properties);
    }
}

