/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.kdc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.crypto.encryption.EncryptionType;

public class KdcConfiguration {
    private static final String DEFAULTS = "kerberos.properties";
    private static final String KDC_PRIMARY_REALM = "kdc.primary.realm";
    private static final String KDC_PRINCIPAL = "kdc.principal";
    private static final int DEFAULT_PORT = 88;
    private static final int CHANGEPW_PORT = 464;
    private static final int BUFFER_SIZE = 1024;
    private static final int MINUTE = 60000;
    private final Properties properties = new Properties();
    private EncryptionType[] _encryptionTypes;

    public KdcConfiguration() {
        this.loadDefaults();
        this.prepareEncryptionTypes();
    }

    public KdcConfiguration(Properties properties) {
        this.loadDefaults();
        this.properties.putAll((Map<?, ?>)properties);
        this.prepareEncryptionTypes();
    }

    private void loadDefaults() {
        try {
            this.properties.load(this.getClass().getResourceAsStream(DEFAULTS));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getPrimaryRealm() {
        String key = KDC_PRIMARY_REALM;
        return (String)this.properties.get(key);
    }

    public KerberosPrincipal getKdcPrincipal() {
        String key = KDC_PRINCIPAL;
        return new KerberosPrincipal((String)this.properties.get(key));
    }

    public String getKerberosKeysLocation() {
        String key = "kdc.keys.location";
        return (String)this.properties.get(key);
    }

    public EncryptionType[] getEncryptionTypes() {
        return this._encryptionTypes;
    }

    public Hashtable getProperties() {
        this.properties.put("java.naming.ldap.attributes.binary", "krb5Key");
        return this.properties;
    }

    public long getClockSkew() {
        String key = "kdc.allowable.clockskew";
        if (this.properties.containsKey(key)) {
            return 60000L * Long.parseLong((String)this.properties.get(key));
        }
        return 300000L;
    }

    public long getMaximumTicketLifetime() {
        String key = "tgs.maximum.ticket.lifetime";
        if (this.properties.containsKey(key)) {
            return 60000L * Long.parseLong((String)this.properties.get(key));
        }
        return 86400000L;
    }

    public long getMaximumRenewableLifetime() {
        String key = "tgs.maximum.renewable.lifetime";
        if (this.properties.containsKey(key)) {
            return 60000L * Long.parseLong((String)this.properties.get(key));
        }
        return 604800000L;
    }

    public int getDefaultPort() {
        String key = "kdc.default.port";
        if (this.properties.containsKey(key)) {
            return Integer.parseInt((String)this.properties.get(key));
        }
        return 88;
    }

    public int getBufferSize() {
        String key = "kdc.buffer.size";
        if (this.properties.containsKey(key)) {
            return Integer.parseInt((String)this.properties.get(key));
        }
        return 1024;
    }

    public boolean isPaEncTimestampRequired() {
        String key = "kdc.pa.enc.timestamp.required";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase((String)this.properties.get(key));
        }
        return true;
    }

    public boolean isEmptyAddressesAllowed() {
        String key = "tgs.empty.addresses.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase((String)this.properties.get(key));
        }
        return true;
    }

    public boolean isForwardableAllowed() {
        String key = "tgs.forwardable.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase((String)this.properties.get(key));
        }
        return true;
    }

    public boolean isProxiableAllowed() {
        String key = "tgs.proxiable.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase((String)this.properties.get(key));
        }
        return true;
    }

    public boolean isPostdateAllowed() {
        String key = "tgs.postdate.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase((String)this.properties.get(key));
        }
        return true;
    }

    public boolean isRenewableAllowed() {
        String key = "tgs.renewable.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase((String)this.properties.get(key));
        }
        return true;
    }

    public int getChangepwPort() {
        String key = "changepw.default.port";
        if (this.properties.containsKey(key)) {
            return Integer.parseInt((String)this.properties.get(key));
        }
        return 464;
    }

    public KerberosPrincipal getChangepwPrincipal() {
        String key = "changepw.principal";
        return new KerberosPrincipal((String)this.properties.get(key));
    }

    public KerberosPrincipal getLdapPrincipal() {
        String key = "ldap.principal";
        if (this.properties.containsKey(key)) {
            return new KerberosPrincipal((String)this.properties.get(key));
        }
        return null;
    }

    private void prepareEncryptionTypes() {
        String key = "kdc.encryption.types";
        String[] encryptionTypes = ((String)this.properties.get(key)).split("\\s");
        ArrayList<EncryptionType> encTypes = new ArrayList<EncryptionType>();
        for (int i = 0; i < encryptionTypes.length; ++i) {
            String enc = encryptionTypes[i];
            Iterator it = EncryptionType.VALUES.iterator();
            while (it.hasNext()) {
                EncryptionType type = (EncryptionType)it.next();
                if (!type.toString().equalsIgnoreCase(enc)) continue;
                encTypes.add(type);
            }
        }
        this._encryptionTypes = encTypes.toArray(new EncryptionType[encTypes.size()]);
    }
}

