/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.kdc;

import java.io.IOException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.crypto.RandomKey;
import org.apache.kerberos.crypto.encryption.EncryptionEngine;
import org.apache.kerberos.crypto.encryption.EncryptionEngineFactory;
import org.apache.kerberos.crypto.encryption.EncryptionType;
import org.apache.kerberos.exceptions.ErrorType;
import org.apache.kerberos.exceptions.KerberosException;
import org.apache.kerberos.io.decoder.EncryptedDataDecoder;
import org.apache.kerberos.io.decoder.EncryptedTimestampDecoder;
import org.apache.kerberos.io.encoder.EncAsRepPartEncoder;
import org.apache.kerberos.io.encoder.EncTicketPartEncoder;
import org.apache.kerberos.io.encoder.EncryptionTypeInfoEncoder;
import org.apache.kerberos.io.encoder.PreAuthenticationDataEncoder;
import org.apache.kerberos.messages.AuthenticationReply;
import org.apache.kerberos.messages.KdcReply;
import org.apache.kerberos.messages.KdcRequest;
import org.apache.kerberos.messages.components.EncTicketPart;
import org.apache.kerberos.messages.components.EncTicketPartModifier;
import org.apache.kerberos.messages.components.Ticket;
import org.apache.kerberos.messages.value.EncryptedData;
import org.apache.kerberos.messages.value.EncryptedTimeStamp;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.EncryptionTypeInfoEntry;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.messages.value.LastRequest;
import org.apache.kerberos.messages.value.PreAuthenticationData;
import org.apache.kerberos.messages.value.PreAuthenticationDataModifier;
import org.apache.kerberos.messages.value.PreAuthenticationDataType;
import org.apache.kerberos.messages.value.TransitedEncoding;
import org.apache.kerberos.sam.SamException;
import org.apache.kerberos.sam.SamSubsystem;
import org.apache.kerberos.sam.TimestampChecker;
import org.apache.kerberos.service.KdcConfiguration;
import org.apache.kerberos.service.KerberosService;
import org.apache.kerberos.store.PrincipalStore;
import org.apache.kerberos.store.PrincipalStoreEntry;

public class AuthenticationService
extends KerberosService {
    public AuthenticationService(KdcConfiguration config, PrincipalStore store) {
        super(config, store);
        SamSubsystem.setEnvironment(config.getProperties());
    }

    public AuthenticationReply getReplyFor(KdcRequest request) throws KerberosException {
        EncryptionKey clientKey = this.verifyPreAuthentication(request);
        Ticket ticket = this.generateNewTicket(request);
        AuthenticationReply reply = this.getAuthenticationReply(request, ticket);
        this.encryptReplyPart(reply, clientKey);
        return reply;
    }

    private EncryptionKey verifyPreAuthentication(KdcRequest request) throws KerberosException {
        KerberosPrincipal clientPrincipal = request.getClientPrincipal();
        PrincipalStoreEntry entry = this.getEntryForClient(clientPrincipal);
        EncryptionKey clientKey = null;
        if (entry.getSamType() == null) {
            clientKey = entry.getEncryptionKey();
            if (clientKey == null) {
                throw new KerberosException(ErrorType.KDC_ERR_NULL_KEY);
            }
            if (this.config.isPaEncTimestampRequired()) {
                PreAuthenticationData[] preAuthData = request.getPreAuthData();
                if (preAuthData == null) {
                    throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_REQUIRED, this.preparePreAuthenticationError());
                }
                EncryptedTimeStamp timestamp = null;
                for (int ii = 0; ii < preAuthData.length; ++ii) {
                    if (!preAuthData[ii].getDataType().equals(PreAuthenticationDataType.PA_ENC_TIMESTAMP)) continue;
                    try {
                        EncryptedData dataValue = EncryptedDataDecoder.decode((byte[])preAuthData[ii].getDataValue());
                        EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor((EncryptionKey)clientKey);
                        byte[] decTimestamp = engine.getDecryptedData(clientKey, dataValue);
                        EncryptedTimestampDecoder timeStampDecoder = new EncryptedTimestampDecoder();
                        timestamp = timeStampDecoder.decode(decTimestamp);
                        continue;
                    }
                    catch (KerberosException ke) {
                        throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
                    }
                    catch (IOException ioe) {
                        throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
                    }
                    catch (ClassCastException cce) {
                        throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
                    }
                }
                if (timestamp == null) {
                    throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_REQUIRED, this.preparePreAuthenticationError());
                }
                if (!timestamp.getTimeStamp().isInClockSkew(this.config.getClockSkew())) {
                    throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_FAILED);
                }
            }
        } else {
            PreAuthenticationData[] preAuthData = request.getPreAuthData();
            if (preAuthData == null || preAuthData.length == 0) {
                throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_REQUIRED, this.preparePreAuthenticationError());
            }
            try {
                for (int ii = 0; ii < preAuthData.length; ++ii) {
                    if (!preAuthData[ii].getDataType().equals(PreAuthenticationDataType.PA_ENC_TIMESTAMP)) continue;
                    KerberosKey samKey = SamSubsystem.verify(entry, preAuthData[ii].getDataValue());
                    clientKey = new EncryptionKey(EncryptionType.getTypeByOrdinal((int)samKey.getKeyType()), samKey.getEncoded());
                }
            }
            catch (SamException se) {
                throw new KerberosException(60, se.getMessage());
            }
        }
        System.out.println("Ticket will be issued to client " + clientPrincipal.toString() + ".");
        return clientKey;
    }

    private byte[] preparePreAuthenticationError() {
        PreAuthenticationData[] paDataSequence = new PreAuthenticationData[2];
        PreAuthenticationDataModifier modifier = new PreAuthenticationDataModifier();
        modifier.setDataType(PreAuthenticationDataType.PA_ENC_TIMESTAMP);
        modifier.setDataValue(new byte[0]);
        paDataSequence[0] = modifier.getPreAuthenticationData();
        EncryptionTypeInfoEntry[] entries = new EncryptionTypeInfoEntry[]{new EncryptionTypeInfoEntry(EncryptionType.DES_CBC_MD5, null)};
        byte[] encTypeInfo = null;
        try {
            encTypeInfo = EncryptionTypeInfoEncoder.encode((EncryptionTypeInfoEntry[])entries);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        PreAuthenticationDataModifier encTypeModifier = new PreAuthenticationDataModifier();
        encTypeModifier.setDataType(PreAuthenticationDataType.PA_ENCTYPE_INFO);
        encTypeModifier.setDataValue(encTypeInfo);
        paDataSequence[1] = encTypeModifier.getPreAuthenticationData();
        try {
            return PreAuthenticationDataEncoder.encode((PreAuthenticationData[])paDataSequence);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private Ticket generateNewTicket(KdcRequest request) throws KerberosException {
        KerberosPrincipal serverPrincipal = request.getServerPrincipal();
        EncryptionKey serverKey = this.getServerKey(serverPrincipal);
        KerberosPrincipal ticketPrincipal = request.getServerPrincipal();
        EncTicketPartModifier newTicketBody = new EncTicketPartModifier();
        if (request.getKdcOptions().get(1)) {
            newTicketBody.setFlag(1);
        }
        if (request.getKdcOptions().get(3)) {
            newTicketBody.setFlag(3);
        }
        if (request.getKdcOptions().get(5)) {
            newTicketBody.setFlag(5);
        }
        if (request.getKdcOptions().get(30) || request.getKdcOptions().get(31) || request.getKdcOptions().get(4) || request.getKdcOptions().get(2) || request.getKdcOptions().get(28)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
        newTicketBody.setSessionKey(new RandomKey().getNewSessionKey());
        newTicketBody.setClientPrincipal(request.getClientPrincipal());
        newTicketBody.setTransitedEncoding(new TransitedEncoding());
        KerberosTime now = new KerberosTime();
        newTicketBody.setAuthTime(now);
        if (request.getKdcOptions().get(6)) {
            if (!this.config.isPostdateAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(7);
            newTicketBody.setStartTime(request.getFrom());
        }
        long till = 0L;
        till = request.getTill().getTime() == 0L ? Long.MAX_VALUE : request.getTill().getTime();
        long endTime = Math.min(now.getTime() + this.config.getMaximumTicketLifetime(), till);
        KerberosTime kerberosEndTime = new KerberosTime(endTime);
        newTicketBody.setEndTime(kerberosEndTime);
        long tempRtime = 0L;
        if (request.getKdcOptions().get(27) && request.getTill().greaterThan(kerberosEndTime)) {
            request.getKdcOptions().set(8);
            tempRtime = request.getTill().getTime();
        }
        tempRtime = tempRtime == 0L ? Long.MAX_VALUE : request.getRtime().getTime();
        if (request.getKdcOptions().get(8)) {
            newTicketBody.setFlag(8);
            KerberosTime fromTime = request.getFrom();
            if (fromTime == null) {
                fromTime = new KerberosTime();
            }
            long renewTill = Math.min(fromTime.getTime() + this.config.getMaximumRenewableLifetime(), tempRtime);
            newTicketBody.setRenewTill(new KerberosTime(renewTill));
        }
        if (request.getAddresses() != null) {
            newTicketBody.setClientAddresses(request.getAddresses());
        }
        EncTicketPart ticketPart = newTicketBody.getEncTicketPart();
        EncryptedData encryptedData = this.encryptTicketPart(ticketPart, serverKey);
        Ticket newTicket = new Ticket(ticketPrincipal, encryptedData);
        newTicket.setEncTicketPart(ticketPart);
        System.out.println("Ticket will be issued for access to " + serverPrincipal.toString() + ".");
        return newTicket;
    }

    private EncryptedData encryptTicketPart(EncTicketPart ticketPart, EncryptionKey serverKey) {
        EncTicketPartEncoder encoder = new EncTicketPartEncoder();
        EncryptedData encryptedTicketPart = null;
        try {
            byte[] plainText = encoder.encode(ticketPart);
            EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor((EncryptionKey)serverKey);
            encryptedTicketPart = engine.getEncryptedData(serverKey, plainText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedTicketPart;
    }

    private void encryptReplyPart(AuthenticationReply reply, EncryptionKey clientKey) {
        EncAsRepPartEncoder encoder = new EncAsRepPartEncoder();
        try {
            byte[] plainText = encoder.encode((KdcReply)reply);
            EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor((EncryptionKey)clientKey);
            EncryptedData cipherText = engine.getEncryptedData(clientKey, plainText);
            reply.setEncPart(cipherText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AuthenticationReply getAuthenticationReply(KdcRequest request, Ticket ticket) {
        AuthenticationReply reply = new AuthenticationReply();
        reply.setClientPrincipal(request.getClientPrincipal());
        reply.setTicket(ticket);
        reply.setKey(ticket.getSessionKey());
        reply.setLastRequest(new LastRequest());
        reply.setNonce(request.getNonce());
        reply.setFlags(ticket.getFlags());
        reply.setAuthTime(ticket.getAuthTime());
        reply.setStartTime(ticket.getStartTime());
        reply.setEndTime(ticket.getEndTime());
        if (ticket.getFlags().get(8)) {
            reply.setRenewTill(ticket.getRenewTill());
        }
        reply.setServerPrincipal(ticket.getServerPrincipal());
        reply.setClientAddresses(ticket.getClientAddresses());
        return reply;
    }

    static {
        SamSubsystem.setIntegrityChecker(new TimestampChecker());
    }
}

