/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl;

import dev.paseto.jpaseto.ExpiredPasetoException;
import dev.paseto.jpaseto.FooterClaims;
import dev.paseto.jpaseto.IncorrectClaimException;
import dev.paseto.jpaseto.KeyResolver;
import dev.paseto.jpaseto.MissingClaimException;
import dev.paseto.jpaseto.Paseto;
import dev.paseto.jpaseto.PasetoParser;
import dev.paseto.jpaseto.PasetoSignatureException;
import dev.paseto.jpaseto.PrematurePasetoException;
import dev.paseto.jpaseto.Purpose;
import dev.paseto.jpaseto.UnsupportedPasetoException;
import dev.paseto.jpaseto.Version;
import dev.paseto.jpaseto.impl.CryptoProviders;
import dev.paseto.jpaseto.impl.DefaultClaims;
import dev.paseto.jpaseto.impl.DefaultFooterClaims;
import dev.paseto.jpaseto.impl.DefaultPaseto;
import dev.paseto.jpaseto.io.Deserializer;
import dev.paseto.jpaseto.lang.Assert;
import dev.paseto.jpaseto.lang.DateFormats;
import dev.paseto.jpaseto.lang.DescribedPredicate;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import javax.crypto.SecretKey;

class DefaultPasetoParser
implements PasetoParser {
    private final KeyResolver keyResolver;
    private final Deserializer<Map<String, Object>> deserializer;
    private final Clock clock;
    private final Duration allowedClockSkew;
    private final Map<String, Predicate<Object>> userExpectedClaimsMap;
    private final Map<String, Predicate<Object>> userExpectedFooterClaimsMap;

    DefaultPasetoParser(KeyResolver keyResolver, Deserializer<Map<String, Object>> deserializer, Clock clock, Duration allowedClockSkew, Map<String, Predicate<Object>> expectedClaimsMap, Map<String, Predicate<Object>> expectedFooterClaimsMap) {
        this.keyResolver = keyResolver;
        this.deserializer = deserializer;
        this.clock = clock;
        this.allowedClockSkew = allowedClockSkew;
        this.userExpectedClaimsMap = Collections.unmodifiableMap(expectedClaimsMap);
        this.userExpectedFooterClaimsMap = Collections.unmodifiableMap(expectedFooterClaimsMap);
    }

    public Paseto parse(String token) {
        Paseto paseto;
        byte[] footerBytes;
        Assert.hasText((String)token, (String)"Paseto token cannot be null or empty");
        String[] parts = token.split("\\.");
        Assert.isTrue((parts.length == 3 || parts.length == 4 ? 1 : 0) != 0, (String)"Paseto token expected to have 3 or 4 parts.");
        Version version = Version.from((String)parts[0]);
        Purpose purpose = Purpose.from((String)parts[1]);
        byte[] payloadBytes = Base64.getUrlDecoder().decode(parts[2].getBytes(StandardCharsets.UTF_8));
        byte[] byArray = footerBytes = parts.length == 4 ? Base64.getUrlDecoder().decode(parts[3].getBytes(StandardCharsets.UTF_8)) : new byte[]{};
        if (version == Version.V2 && purpose == Purpose.LOCAL) {
            paseto = this.v2Local(payloadBytes, footerBytes);
        } else if (version == Version.V2 && purpose == Purpose.PUBLIC) {
            paseto = this.v2Public(payloadBytes, footerBytes);
        } else if (version == Version.V1 && purpose == Purpose.LOCAL) {
            paseto = this.v1Local(payloadBytes, footerBytes);
        } else if (version == Version.V1 && purpose == Purpose.PUBLIC) {
            paseto = this.v1Public(payloadBytes, footerBytes);
        } else {
            throw new UnsupportedPasetoException("Paseto token with header: '" + version.toString() + "." + purpose.toString() + ".' is not supported.");
        }
        this.verifyExpiration(paseto);
        this.verifyNotBefore(paseto);
        this.validateExpectedClaims(paseto);
        this.validateExpectedFooterClaims(paseto);
        return paseto;
    }

    private Paseto v2Local(byte[] encryptedBytes, byte[] footerBytes) {
        FooterClaims footer = this.toFooter(footerBytes);
        SecretKey sharedSecret = this.keyResolver.resolveSharedKey(Version.V2, Purpose.LOCAL, footer);
        Assert.notNull((Object)sharedSecret, (String)"A shared secret could not be resolved.  A shared secret must be configured in 'Pasetos.parserBuilder().setSharedSecret(...)' or Pasetos.parserBuilder().setKeyResolver(...)");
        byte[] payload = CryptoProviders.v2LocalCryptoProvider().decrypt(encryptedBytes, footerBytes, sharedSecret);
        Map claims = (Map)this.deserializer.deserialize(payload);
        return new DefaultPaseto(Version.V2, Purpose.LOCAL, new DefaultClaims(claims), footer);
    }

    private Paseto v1Public(byte[] payload, byte[] footerBytes) {
        FooterClaims footer = this.toFooter(footerBytes);
        byte[] message = Arrays.copyOf(payload, payload.length - 256);
        byte[] signature = Arrays.copyOfRange(payload, payload.length - 256, payload.length);
        PublicKey publicKey = this.keyResolver.resolvePublicKey(Version.V1, Purpose.PUBLIC, footer);
        Assert.notNull((Object)publicKey, (String)"A public key could not be resolved.  A public key must be configured in 'Pasetos.parserBuilder().setPublicKey(...)' or Pasetos.parserBuilder().setKeyResolver(...)");
        boolean valid = CryptoProviders.v1PublicCryptoProvider().verify(message, footerBytes, signature, publicKey);
        if (!valid) {
            throw new PasetoSignatureException("Signature could not be validated in paseto token.");
        }
        Map claims = (Map)this.deserializer.deserialize(message);
        return new DefaultPaseto(Version.V1, Purpose.PUBLIC, new DefaultClaims(claims), footer);
    }

    private Paseto v1Local(byte[] encryptedBytes, byte[] footerBytes) {
        FooterClaims footer = this.toFooter(footerBytes);
        SecretKey sharedSecret = this.keyResolver.resolveSharedKey(Version.V1, Purpose.LOCAL, footer);
        Assert.notNull((Object)sharedSecret, (String)"A shared secret could not be resolved.  A shared secret must be configured in 'Pasetos.parserBuilder().setSharedSecret(...)' or Pasetos.parserBuilder().setKeyResolver(...)");
        byte[] nonce = Arrays.copyOf(encryptedBytes, 32);
        byte[] payload = CryptoProviders.v1LocalCryptoProvider().decrypt(encryptedBytes, footerBytes, nonce, sharedSecret);
        Map claims = (Map)this.deserializer.deserialize(payload);
        return new DefaultPaseto(Version.V1, Purpose.LOCAL, new DefaultClaims(claims), footer);
    }

    private Paseto v2Public(byte[] payload, byte[] footerBytes) {
        FooterClaims footer = this.toFooter(footerBytes);
        byte[] message = Arrays.copyOf(payload, payload.length - 64);
        byte[] signature = Arrays.copyOfRange(payload, payload.length - 64, payload.length);
        PublicKey publicKey = this.keyResolver.resolvePublicKey(Version.V2, Purpose.PUBLIC, footer);
        Assert.notNull((Object)publicKey, (String)"A public key could not be resolved.  A public key must be configured in 'Pasetos.parserBuilder().setPublicKey(...)' or Pasetos.parserBuilder().setKeyResolver(...)");
        boolean valid = CryptoProviders.v2PublicCryptoProvider().verify(message, footerBytes, signature, publicKey);
        if (!valid) {
            throw new PasetoSignatureException("Signature could not be validated in paseto token.");
        }
        Map claims = (Map)this.deserializer.deserialize(message);
        return new DefaultPaseto(Version.V2, Purpose.PUBLIC, new DefaultClaims(claims), footer);
    }

    private FooterClaims toFooter(byte[] footerBytes) {
        if (footerBytes.length != 0) {
            if (footerBytes[0] == 123 && footerBytes[footerBytes.length - 1] == 125) {
                return new DefaultFooterClaims((Map)this.deserializer.deserialize(footerBytes));
            }
            return new DefaultFooterClaims(new String(footerBytes, StandardCharsets.UTF_8));
        }
        return new DefaultFooterClaims("");
    }

    private void verifyNotBefore(Paseto paseto) {
        Instant min;
        Instant now = this.clock.instant();
        Instant nbf = paseto.getClaims().getNotBefore();
        if (nbf != null && (min = now.plus(this.allowedClockSkew)).isBefore(nbf)) {
            String nbfVal = DateFormats.formatIso8601((Instant)nbf);
            String nowVal = DateFormats.formatIso8601((Instant)now);
            Duration diff = Duration.between(nbf, min);
            String msg = "JWT must not be accepted before " + nbfVal + ". Current time: " + nowVal + ", a difference of " + diff + ".  Allowed clock skew: " + this.allowedClockSkew + ".";
            throw new PrematurePasetoException(paseto, msg);
        }
    }

    private void verifyExpiration(Paseto paseto) {
        Instant max;
        Instant now = this.clock.instant();
        Instant exp = paseto.getClaims().getExpiration();
        if (exp != null && (max = now.minus(this.allowedClockSkew)).isAfter(exp)) {
            String expVal = DateFormats.formatIso8601((Instant)exp);
            String nowVal = DateFormats.formatIso8601((Instant)now);
            Duration diff = Duration.between(max, exp);
            String msg = "Paseto expired at " + expVal + ". Current time: " + nowVal + ", a difference of " + diff + ".  Allowed clock skew: " + this.allowedClockSkew + ".";
            throw new ExpiredPasetoException(paseto, msg);
        }
    }

    private void validateExpectedClaims(Paseto paseto) {
        this.validateExpected(paseto, (Map<String, Object>)paseto.getClaims(), this.userExpectedClaimsMap);
    }

    private void validateExpectedFooterClaims(Paseto paseto) {
        this.validateExpected(paseto, (Map<String, Object>)paseto.getFooter(), this.userExpectedFooterClaimsMap);
    }

    private void validateExpected(Paseto paseto, Map<String, Object> claims, Map<String, Predicate<Object>> expectedClaims) {
        expectedClaims.forEach((claimName, predicate) -> {
            Object actualClaimValue = DefaultPasetoParser.normalize(claims.get(claimName));
            MissingClaimException invalidClaimException = null;
            String description = "<unnamed predicate>";
            if (predicate instanceof DescribedPredicate) {
                description = ((DescribedPredicate)predicate).getDescription();
            }
            if (actualClaimValue == null) {
                String msg = String.format("Expected '%s' claim to be %s, but was not present in the paseto claims.", claimName, description);
                invalidClaimException = new MissingClaimException(paseto, claimName, description, msg);
            } else if (!predicate.test(actualClaimValue)) {
                String msg = String.format("Expected '%s' claim to be %s, but was: '%s'.", claimName, description, actualClaimValue);
                invalidClaimException = new IncorrectClaimException(paseto, claimName, description, msg);
            }
            if (invalidClaimException != null) {
                throw invalidClaimException;
            }
        });
    }

    private static Object normalize(Object o) {
        if (o instanceof Integer) {
            o = ((Integer)o).longValue();
        }
        return o;
    }
}

