/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.internal.TriConsumer;

public abstract class EventProvider
implements FeatureProvider {
    private TriConsumer<EventProvider, ProviderEvent, ProviderEventDetails> onEmit = null;

    @Override
    public abstract ProviderState getState();

    void attach(TriConsumer<EventProvider, ProviderEvent, ProviderEventDetails> onEmit) {
        if (this.onEmit != null && this.onEmit != onEmit) {
            throw new IllegalStateException("Provider " + this.getMetadata().getName() + " is already attached.");
        }
        this.onEmit = onEmit;
    }

    void detach() {
        this.onEmit = null;
    }

    public void emit(ProviderEvent event, ProviderEventDetails details) {
        if (this.onEmit != null) {
            this.onEmit.accept(this, event, details);
        }
    }

    public void emitProviderReady(ProviderEventDetails details) {
        this.emit(ProviderEvent.PROVIDER_READY, details);
    }

    public void emitProviderConfigurationChanged(ProviderEventDetails details) {
        this.emit(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, details);
    }

    public void emitProviderStale(ProviderEventDetails details) {
        this.emit(ProviderEvent.PROVIDER_STALE, details);
    }

    public void emitProviderError(ProviderEventDetails details) {
        this.emit(ProviderEvent.PROVIDER_ERROR, details);
    }
}

