/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk.hooks.logging;

import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FlagEvaluationDetails;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.HookContext;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LoggingEventBuilder;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="we can ignore return values of chainables (builders) here")
public class LoggingHook
implements Hook<Object> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingHook.class);
    static final String DOMAIN_KEY = "domain";
    static final String PROVIDER_NAME_KEY = "provider_name";
    static final String FLAG_KEY_KEY = "flag_key";
    static final String DEFAULT_VALUE_KEY = "default_value";
    static final String EVALUATION_CONTEXT_KEY = "evaluation_context";
    static final String ERROR_CODE_KEY = "error_code";
    static final String ERROR_MESSAGE_KEY = "error_message";
    static final String REASON_KEY = "reason";
    static final String VARIANT_KEY = "variant";
    static final String VALUE_KEY = "value";
    private boolean includeEvaluationContext;

    public LoggingHook() {
        this(false);
    }

    public LoggingHook(boolean includeEvaluationContext) {
        this.includeEvaluationContext = includeEvaluationContext;
    }

    @Override
    public Optional<EvaluationContext> before(HookContext<Object> hookContext, Map<String, Object> hints) {
        LoggingEventBuilder builder = log.atDebug();
        this.addCommonProps(builder, hookContext);
        builder.log("Before stage");
        return Optional.empty();
    }

    @Override
    public void after(HookContext<Object> hookContext, FlagEvaluationDetails<Object> details, Map<String, Object> hints) {
        LoggingEventBuilder builder = log.atDebug().addKeyValue(REASON_KEY, (Object)details.getReason()).addKeyValue(VARIANT_KEY, (Object)details.getVariant()).addKeyValue(VALUE_KEY, details.getValue());
        this.addCommonProps(builder, hookContext);
        builder.log("After stage");
    }

    @Override
    public void error(HookContext<Object> hookContext, Exception error, Map<String, Object> hints) {
        LoggingEventBuilder builder = log.atError().addKeyValue(ERROR_MESSAGE_KEY, (Object)error.getMessage());
        this.addCommonProps(builder, hookContext);
        ErrorCode errorCode = error instanceof OpenFeatureError ? ((OpenFeatureError)error).getErrorCode() : null;
        builder.addKeyValue(ERROR_CODE_KEY, (Object)errorCode);
        builder.log("Error stage", (Object)error);
    }

    private void addCommonProps(LoggingEventBuilder builder, HookContext<Object> hookContext) {
        builder.addKeyValue(DOMAIN_KEY, (Object)hookContext.getClientMetadata().getDomain()).addKeyValue(PROVIDER_NAME_KEY, (Object)hookContext.getProviderMetadata().getName()).addKeyValue(FLAG_KEY_KEY, (Object)hookContext.getFlagKey()).addKeyValue(DEFAULT_VALUE_KEY, hookContext.getDefaultValue());
        if (this.includeEvaluationContext) {
            builder.addKeyValue(EVALUATION_CONTEXT_KEY, (Object)hookContext.getCtx());
        }
    }
}

