/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.EventProviderListener;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;

class FeatureProviderStateManager
implements EventProviderListener {
    private final FeatureProvider delegate;
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private ProviderState state = ProviderState.NOT_READY;

    public FeatureProviderStateManager(FeatureProvider delegate) {
        this.delegate = delegate;
        if (delegate instanceof EventProvider) {
            ((EventProvider)delegate).setEventProviderListener(this);
        }
    }

    public void initialize(EvaluationContext evaluationContext) throws Exception {
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        try {
            this.delegate.initialize(evaluationContext);
            this.state = ProviderState.READY;
        }
        catch (OpenFeatureError openFeatureError) {
            this.state = ErrorCode.PROVIDER_FATAL.equals((Object)openFeatureError.getErrorCode()) ? ProviderState.FATAL : ProviderState.ERROR;
            this.isInitialized.set(false);
            throw openFeatureError;
        }
        catch (Exception e) {
            this.state = ProviderState.ERROR;
            this.isInitialized.set(false);
            throw e;
        }
    }

    public void shutdown() {
        this.delegate.shutdown();
        this.state = ProviderState.NOT_READY;
        this.isInitialized.set(false);
    }

    @Override
    public void onEmit(ProviderEvent event, ProviderEventDetails details) {
        if (ProviderEvent.PROVIDER_ERROR.equals((Object)event)) {
            this.state = details != null && details.getErrorCode() == ErrorCode.PROVIDER_FATAL ? ProviderState.FATAL : ProviderState.ERROR;
        } else if (ProviderEvent.PROVIDER_STALE.equals((Object)event)) {
            this.state = ProviderState.STALE;
        } else if (ProviderEvent.PROVIDER_READY.equals((Object)event)) {
            this.state = ProviderState.READY;
        }
    }

    FeatureProvider getProvider() {
        return this.delegate;
    }

    public boolean hasSameProvider(FeatureProvider featureProvider) {
        return this.delegate.equals(featureProvider);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProviderState getState() {
        return this.state;
    }
}

