/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.FeatureProviderStateManager;
import dev.openfeature.sdk.NoOpProvider;
import dev.openfeature.sdk.OpenFeatureAPI;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProviderRepository {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProviderRepository.class);
    private final Map<String, FeatureProviderStateManager> stateManagers = new ConcurrentHashMap<String, FeatureProviderStateManager>();
    private final AtomicReference<FeatureProviderStateManager> defaultStateManger = new AtomicReference<FeatureProviderStateManager>(new FeatureProviderStateManager(new NoOpProvider()));
    private final ExecutorService taskExecutor = Executors.newCachedThreadPool(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    });
    private final Object registerStateManagerLock = new Object();

    ProviderRepository() {
    }

    FeatureProviderStateManager getFeatureProviderStateManager() {
        return this.defaultStateManger.get();
    }

    FeatureProviderStateManager getFeatureProviderStateManager(String domain) {
        if (domain == null) {
            return this.defaultStateManger.get();
        }
        FeatureProviderStateManager fromMap = this.stateManagers.get(domain);
        if (fromMap == null) {
            return this.defaultStateManger.get();
        }
        return fromMap;
    }

    public FeatureProvider getProvider() {
        return this.defaultStateManger.get().getProvider();
    }

    public FeatureProvider getProvider(String domain) {
        return this.getFeatureProviderStateManager(domain).getProvider();
    }

    public ProviderState getProviderState() {
        return this.getFeatureProviderStateManager().getState();
    }

    public ProviderState getProviderState(FeatureProvider featureProvider) {
        if (featureProvider instanceof FeatureProviderStateManager) {
            return ((FeatureProviderStateManager)((Object)featureProvider)).getState();
        }
        FeatureProviderStateManager defaultProvider = this.defaultStateManger.get();
        if (defaultProvider.hasSameProvider(featureProvider)) {
            return defaultProvider.getState();
        }
        for (FeatureProviderStateManager wrapper : this.stateManagers.values()) {
            if (!wrapper.hasSameProvider(featureProvider)) continue;
            return wrapper.getState();
        }
        return null;
    }

    public ProviderState getProviderState(String domain) {
        return Optional.ofNullable(domain).map(this.stateManagers::get).orElse(this.defaultStateManger.get()).getState();
    }

    public List<String> getDomainsForProvider(FeatureProvider provider) {
        return this.stateManagers.entrySet().stream().filter(entry -> ((FeatureProviderStateManager)entry.getValue()).hasSameProvider(provider)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Set<String> getAllBoundDomains() {
        return this.stateManagers.keySet();
    }

    public boolean isDefaultProvider(FeatureProvider provider) {
        return this.getProvider().equals(provider);
    }

    public void setProvider(FeatureProvider provider, Consumer<FeatureProvider> afterSet, Consumer<FeatureProvider> afterInit, Consumer<FeatureProvider> afterShutdown, BiConsumer<FeatureProvider, OpenFeatureError> afterError, boolean waitForInit) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        this.prepareAndInitializeProvider(null, provider, afterSet, afterInit, afterShutdown, afterError, waitForInit);
    }

    public void setProvider(String domain, FeatureProvider provider, Consumer<FeatureProvider> afterSet, Consumer<FeatureProvider> afterInit, Consumer<FeatureProvider> afterShutdown, BiConsumer<FeatureProvider, OpenFeatureError> afterError, boolean waitForInit) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null");
        }
        this.prepareAndInitializeProvider(domain, provider, afterSet, afterInit, afterShutdown, afterError, waitForInit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndInitializeProvider(String domain, FeatureProvider newProvider, Consumer<FeatureProvider> afterSet, Consumer<FeatureProvider> afterInit, Consumer<FeatureProvider> afterShutdown, BiConsumer<FeatureProvider, OpenFeatureError> afterError, boolean waitForInit) {
        FeatureProviderStateManager oldStateManager;
        FeatureProviderStateManager newStateManager;
        Object object = this.registerStateManagerLock;
        synchronized (object) {
            FeatureProviderStateManager existing = this.getExistingStateManagerForProvider(newProvider);
            if (existing == null) {
                newStateManager = new FeatureProviderStateManager(newProvider);
                afterSet.accept(newProvider);
            } else {
                newStateManager = existing;
            }
            oldStateManager = domain != null ? this.stateManagers.put(domain, newStateManager) : this.defaultStateManger.getAndSet(newStateManager);
        }
        if (waitForInit) {
            this.initializeProvider(newStateManager, afterInit, afterShutdown, afterError, oldStateManager);
        } else {
            this.taskExecutor.submit(() -> this.initializeProvider(newStateManager, afterInit, afterShutdown, afterError, oldStateManager));
        }
    }

    private FeatureProviderStateManager getExistingStateManagerForProvider(FeatureProvider provider) {
        for (FeatureProviderStateManager stateManager : this.stateManagers.values()) {
            if (!stateManager.hasSameProvider(provider)) continue;
            return stateManager;
        }
        FeatureProviderStateManager defaultFeatureProviderStateManager = this.defaultStateManger.get();
        if (defaultFeatureProviderStateManager.hasSameProvider(provider)) {
            return defaultFeatureProviderStateManager;
        }
        return null;
    }

    private void initializeProvider(FeatureProviderStateManager newManager, Consumer<FeatureProvider> afterInit, Consumer<FeatureProvider> afterShutdown, BiConsumer<FeatureProvider, OpenFeatureError> afterError, FeatureProviderStateManager oldManager) {
        try {
            if (ProviderState.NOT_READY.equals((Object)newManager.getState())) {
                newManager.initialize(OpenFeatureAPI.getInstance().getEvaluationContext());
                afterInit.accept(newManager.getProvider());
            }
            this.shutDownOld(oldManager, afterShutdown);
        }
        catch (OpenFeatureError e) {
            log.error("Exception when initializing feature provider {}", (Object)newManager.getProvider().getClass().getName(), (Object)e);
            afterError.accept(newManager.getProvider(), e);
        }
        catch (Exception e) {
            log.error("Exception when initializing feature provider {}", (Object)newManager.getProvider().getClass().getName(), (Object)e);
            afterError.accept(newManager.getProvider(), new GeneralError(e));
        }
    }

    private void shutDownOld(FeatureProviderStateManager oldManager, Consumer<FeatureProvider> afterShutdown) {
        if (oldManager != null && !this.isStateManagerRegistered(oldManager)) {
            this.shutdownProvider(oldManager);
            afterShutdown.accept(oldManager.getProvider());
        }
    }

    private boolean isStateManagerRegistered(FeatureProviderStateManager manager) {
        return manager != null && (this.stateManagers.containsValue(manager) || this.defaultStateManger.get().equals(manager));
    }

    private void shutdownProvider(FeatureProviderStateManager manager) {
        if (manager == null) {
            return;
        }
        this.shutdownProvider(manager.getProvider());
    }

    private void shutdownProvider(FeatureProvider provider) {
        this.taskExecutor.submit(() -> {
            try {
                provider.shutdown();
            }
            catch (Exception e) {
                log.error("Exception when shutting down feature provider {}", (Object)provider.getClass().getName(), (Object)e);
            }
        });
    }

    public void shutdown() {
        Stream.concat(Stream.of(this.defaultStateManger.get()), this.stateManagers.values().stream()).distinct().forEach(this::shutdownProvider);
        this.stateManagers.clear();
        this.taskExecutor.shutdown();
    }
}

