/*
 * Decompiled with CFR 0.152.
 */
package dev.micheleferretti.mapboxpluginoffline;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import androidx.core.app.NotificationManagerCompat;
import com.mapbox.mapboxsdk.offline.OfflineManager;
import com.mapbox.mapboxsdk.offline.OfflineRegion;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineRegionError;
import com.mapbox.mapboxsdk.offline.OfflineRegionStatus;
import dev.micheleferretti.mapboxpluginoffline.OfflineDownloadReceiver;
import dev.micheleferretti.mapboxpluginoffline.model.OfflineDownloadJob;
import dev.micheleferretti.mapboxpluginoffline.model.OfflineDownloadOptions;
import dev.micheleferretti.mapboxpluginoffline.utils.ExtensionsKt;
import dev.micheleferretti.mapboxpluginoffline.utils.NotificationUtils;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\"\u0010\u0012\u001a\u00020\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0006H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/micheleferretti/mapboxpluginoffline/OfflineService;", "Landroid/app/Service;", "()V", "jobs", "Ljava/util/HashMap;", "", "Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadJob;", "Lkotlin/collections/HashMap;", "notificationManager", "Landroidx/core/app/NotificationManagerCompat;", "finishJob", "", "regionId", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onStartCommand", "", "flags", "startId", "startJob", "job", "Companion", "mapboxpluginoffline-2.2.2_release"})
public final class OfflineService
extends Service {
    private NotificationManagerCompat notificationManager;
    private final HashMap<Long, OfflineDownloadJob> jobs;
    private static final String CONSTANT_PREFIX = "dev.micheleferretti.mapboxpluginoffline.OfflineService";
    @NotNull
    public static final String ACTION_DOWNLOAD = "dev.micheleferretti.mapboxpluginoffline.OfflineService.action.DOWNLOAD";
    @NotNull
    public static final String ACTION_CANCEL = "dev.micheleferretti.mapboxpluginoffline.OfflineService.action.CANCEL";
    private static final String EXTRA_OPTIONS = "dev.micheleferretti.mapboxpluginoffline.OfflineService.extra.OPTIONS";
    private static final String EXTRA_REGION_ID = "dev.micheleferretti.mapboxpluginoffline.OfflineService.extra.REGION_ID";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public IBinder onBind(@Nullable Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"NotificationManagerCompat.from(applicationContext)");
        this.notificationManager = notificationManagerCompat;
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        NotificationUtils.INSTANCE.setupNotificationChannel(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        Intent intent2 = intent;
        if (intent2 == null) return 1;
        String string = intent2.getAction();
        if (string == null) return 1;
        String string2 = string;
        switch (string2.hashCode()) {
            case 1896416394: {
                if (!string2.equals(ACTION_CANCEL)) return 1;
                break;
            }
            case -1353951592: {
                if (!string2.equals(ACTION_DOWNLOAD)) return 1;
                Bundle bundle = intent.getExtras();
                OfflineDownloadOptions offlineDownloadOptions = bundle != null ? (OfflineDownloadOptions)bundle.getParcelable(EXTRA_OPTIONS) : null;
                boolean bl = false;
                boolean bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (offlineDownloadOptions == null) {
                    boolean bl4 = false;
                    String string3 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                OfflineDownloadOptions options = offlineDownloadOptions;
                OfflineManager offlineManager = OfflineManager.getInstance((Context)this.getApplicationContext());
                OfflineRegionDefinition offlineRegionDefinition = options.getDefinition();
                byte[] byArray = options.getMetadata();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                offlineManager.createOfflineRegion(offlineRegionDefinition, byArray, new OfflineManager.CreateOfflineRegionCallback(this, options){
                    final /* synthetic */ OfflineService this$0;
                    final /* synthetic */ OfflineDownloadOptions $options;

                    public void onCreate(@Nullable OfflineRegion offlineRegion) {
                        if (offlineRegion == null) {
                            this.onError("offlineRegion is null");
                        } else {
                            Context context = this.this$0.getApplicationContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                            OfflineService.access$startJob(this.this$0, new OfflineDownloadJob(context, this.$options, offlineRegion));
                        }
                    }

                    public void onError(@Nullable String error) {
                        Context context = this.this$0.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                        OfflineDownloadReceiver.Companion.dispatchCreateError(context, this.$options, error);
                    }
                    {
                        this.this$0 = this$0;
                        this.$options = $captured_local_variable$1;
                    }
                });
                return 1;
            }
        }
        Bundle bundle = intent.getExtras();
        boolean bl = false;
        boolean bl5 = false;
        bl5 = false;
        boolean bl6 = false;
        if (bundle == null) {
            boolean bl7 = false;
            String string4 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        long regionId = ExtensionsKt.requireLong(bundle, EXTRA_REGION_ID);
        OfflineDownloadJob job = this.jobs.get(regionId);
        if (job == null) return 1;
        NotificationManagerCompat notificationManagerCompat = this.notificationManager;
        if (notificationManagerCompat == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationManager");
        }
        notificationManagerCompat.notify((int)job.getRegion().getID(), job.getNotificationCancel());
        job.getRegion().setDownloadState(0);
        job.getRegion().setObserver(null);
        job.getRegion().delete(new OfflineRegion.OfflineRegionDeleteCallback(this, job, regionId){
            final /* synthetic */ OfflineService this$0;
            final /* synthetic */ OfflineDownloadJob $job;
            final /* synthetic */ long $regionId;

            public void onDelete() {
                Context context = this.this$0.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                OfflineDownloadReceiver.Companion.dispatchDelete(context, this.$job.getDownload());
                OfflineService.access$finishJob(this.this$0, this.$regionId);
            }

            public void onError(@Nullable String error) {
                Context context = this.this$0.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                OfflineDownloadReceiver.Companion.dispatchDeleteError(context, this.$job.getDownload(), error);
                OfflineService.access$finishJob(this.this$0, this.$regionId);
            }
            {
                this.this$0 = this$0;
                this.$job = $captured_local_variable$1;
                this.$regionId = $captured_local_variable$2;
            }
        });
        return 1;
    }

    private final void startJob(OfflineDownloadJob job) {
        ((Map)this.jobs).put(job.getRegion().getID(), job);
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        OfflineDownloadReceiver.Companion.dispatchCreate(context, job.getDownload());
        job.getRegion().setObserver(new OfflineRegion.OfflineRegionObserver(this, job){
            final /* synthetic */ OfflineService this$0;
            final /* synthetic */ OfflineDownloadJob $job;

            public void onStatusChanged(@Nullable OfflineRegionStatus status) {
                if (status == null) {
                    return;
                }
                if (status.isComplete()) {
                    this.$job.getRegion().setDownloadState(0);
                    this.$job.getRegion().setObserver(null);
                    this.$job.getDownload().setStatus$mapboxpluginoffline_2_2_2_release(status);
                    Context context = this.this$0.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                    OfflineDownloadReceiver.Companion.dispatchStatusChanged(context, this.$job.getDownload());
                    OfflineService.access$finishJob(this.this$0, this.$job.getRegion().getID());
                } else {
                    int oldPercentage = this.$job.getDownload().getPercentage();
                    int newPercentage = ExtensionsKt.getCompletionPercentage(status);
                    if (newPercentage >= oldPercentage + 2) {
                        this.$job.getDownload().setStatus$mapboxpluginoffline_2_2_2_release(status);
                        OfflineService.access$getNotificationManager$p(this.this$0).notify((int)this.$job.getRegion().getID(), this.$job.getNotificationDownload());
                        Context context = this.this$0.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                        OfflineDownloadReceiver.Companion.dispatchStatusChanged(context, this.$job.getDownload());
                    }
                }
            }

            public void onError(@Nullable OfflineRegionError error) {
                Context context = this.this$0.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                OfflineRegionError offlineRegionError = error;
                OfflineRegionError offlineRegionError2 = error;
                OfflineDownloadReceiver.Companion.dispatchObserverError(context, this.$job.getDownload(), offlineRegionError != null ? offlineRegionError.getReason() : null, offlineRegionError2 != null ? offlineRegionError2.getMessage() : null);
                OfflineService.access$finishJob(this.this$0, this.$job.getRegion().getID());
            }

            public void mapboxTileCountLimitExceeded(long limit) {
                Context context = this.this$0.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                OfflineDownloadReceiver.Companion.dispatchTileCountLimitExceeded(context, this.$job.getDownload(), limit);
                OfflineService.access$finishJob(this.this$0, this.$job.getRegion().getID());
            }
            {
                this.this$0 = this$0;
                this.$job = $captured_local_variable$1;
            }
        });
        job.getRegion().setDownloadState(1);
        this.startForeground((int)job.getRegion().getID(), job.getNotificationDownload());
    }

    private final synchronized void finishJob(long regionId) {
        OfflineDownloadJob job = this.jobs.remove(regionId);
        if (job != null) {
            NotificationManagerCompat notificationManagerCompat = this.notificationManager;
            if (notificationManagerCompat == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationManager");
            }
            notificationManagerCompat.cancel((int)regionId);
            job.cancelSnapshotter();
        }
        if (this.jobs.isEmpty()) {
            this.stopForeground(false);
            this.stopSelf();
        }
    }

    public OfflineService() {
        boolean bl = false;
        this.jobs = new HashMap();
    }

    public static final /* synthetic */ void access$startJob(OfflineService $this, OfflineDownloadJob job) {
        $this.startJob(job);
    }

    public static final /* synthetic */ void access$finishJob(OfflineService $this, long regionId) {
        $this.finishJob(regionId);
    }

    public static final /* synthetic */ NotificationManagerCompat access$getNotificationManager$p(OfflineService $this) {
        NotificationManagerCompat notificationManagerCompat = $this.notificationManager;
        if (notificationManagerCompat == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationManager");
        }
        return notificationManagerCompat;
    }

    public static final /* synthetic */ void access$setNotificationManager$p(OfflineService $this, NotificationManagerCompat notificationManagerCompat) {
        $this.notificationManager = notificationManagerCompat;
    }

    @JvmStatic
    public static final void startDownload(@NotNull Context context, @NotNull OfflineDownloadOptions offlineDownloadOptions) {
        Companion.startDownload(context, offlineDownloadOptions);
    }

    @JvmStatic
    public static final void cancelDownload(@NotNull Context context, long regionId) {
        Companion.cancelDownload(context, regionId);
    }

    @JvmStatic
    @NotNull
    public static final Intent createIntent$mapboxpluginoffline_2_2_2_release(@NotNull Context context, @NotNull String intentAction, long regionId) {
        return Companion.createIntent$mapboxpluginoffline_2_2_2_release(context, intentAction, regionId);
    }

    @JvmStatic
    @NotNull
    public static final Intent createIntent$mapboxpluginoffline_2_2_2_release(@NotNull Context context, @NotNull String intentAction, @NotNull Function1<? super Bundle, Unit> extrasBlock) {
        return Companion.createIntent$mapboxpluginoffline_2_2_2_release(context, intentAction, extrasBlock);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00042\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n0\u0013\u00a2\u0006\u0002\b\u0015H\u0001\u00a2\u0006\u0002\b\u0016J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/micheleferretti/mapboxpluginoffline/OfflineService$Companion;", "", "()V", "ACTION_CANCEL", "", "ACTION_DOWNLOAD", "CONSTANT_PREFIX", "EXTRA_OPTIONS", "EXTRA_REGION_ID", "cancelDownload", "", "context", "Landroid/content/Context;", "regionId", "", "createIntent", "Landroid/content/Intent;", "intentAction", "extrasBlock", "Lkotlin/Function1;", "Landroid/os/Bundle;", "Lkotlin/ExtensionFunctionType;", "createIntent$mapboxpluginoffline_2_2_2_release", "startDownload", "offlineDownloadOptions", "Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;", "mapboxpluginoffline-2.2.2_release"})
    public static final class Companion {
        @JvmStatic
        public final void startDownload(@NotNull Context context, @NotNull OfflineDownloadOptions offlineDownloadOptions) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)offlineDownloadOptions, (String)"offlineDownloadOptions");
            context.startService(this.createIntent$mapboxpluginoffline_2_2_2_release(context, OfflineService.ACTION_DOWNLOAD, (Function1<? super Bundle, Unit>)((Function1)new Function1<Bundle, Unit>(offlineDownloadOptions){
                final /* synthetic */ OfflineDownloadOptions $offlineDownloadOptions;

                public final void invoke(@NotNull Bundle $this$createIntent) {
                    Intrinsics.checkNotNullParameter((Object)$this$createIntent, (String)"$receiver");
                    $this$createIntent.putParcelable("dev.micheleferretti.mapboxpluginoffline.OfflineService.extra.OPTIONS", (Parcelable)this.$offlineDownloadOptions);
                }
                {
                    this.$offlineDownloadOptions = offlineDownloadOptions;
                    super(1);
                }
            })));
        }

        @JvmStatic
        public final void cancelDownload(@NotNull Context context, long regionId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.startService(this.createIntent$mapboxpluginoffline_2_2_2_release(context, OfflineService.ACTION_CANCEL, regionId));
        }

        @JvmStatic
        @NotNull
        public final Intent createIntent$mapboxpluginoffline_2_2_2_release(@NotNull Context context, @NotNull String intentAction, long regionId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intentAction, (String)"intentAction");
            return this.createIntent$mapboxpluginoffline_2_2_2_release(context, intentAction, (Function1<? super Bundle, Unit>)((Function1)new Function1<Bundle, Unit>(regionId){
                final /* synthetic */ long $regionId;

                public final void invoke(@NotNull Bundle $this$createIntent) {
                    Intrinsics.checkNotNullParameter((Object)$this$createIntent, (String)"$receiver");
                    $this$createIntent.putLong("dev.micheleferretti.mapboxpluginoffline.OfflineService.extra.REGION_ID", this.$regionId);
                }
                {
                    this.$regionId = l;
                    super(1);
                }
            }));
        }

        @JvmStatic
        @NotNull
        public final Intent createIntent$mapboxpluginoffline_2_2_2_release(@NotNull Context context, @NotNull String intentAction, @NotNull Function1<? super Bundle, Unit> extrasBlock) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intentAction, (String)"intentAction");
            Intrinsics.checkNotNullParameter(extrasBlock, (String)"extrasBlock");
            Intent intent = new Intent(intentAction, null, context, OfflineService.class);
            Bundle bundle = new Bundle();
            boolean bl = false;
            boolean bl2 = false;
            extrasBlock.invoke((Object)bundle);
            Intent intent2 = intent.putExtras(bundle);
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent(intentAction, nul\u2026dle().apply(extrasBlock))");
            return intent2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

