/*
 * Decompiled with CFR 0.152.
 */
package dev.micheleferretti.mapboxpluginoffline.utils;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0006\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0015\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/micheleferretti/mapboxpluginoffline/utils/OfflineUtils;", "", "()V", "KEY_REGION_NAME", "", "TAG", "convertRegionName", "regionName", "", "getCompletionPercentage", "", "completedResourceCount", "", "requiredResourceCount", "getRegionIdFromIntent", "intent", "Landroid/content/Intent;", "(Landroid/content/Intent;)Ljava/lang/Long;", "mapboxpluginoffline-2.2.1_release"})
public final class OfflineUtils {
    private static final String TAG = "OfflineUtils";
    private static final String KEY_REGION_NAME = "key.REGION_NAME";
    public static final OfflineUtils INSTANCE;

    @Nullable
    public final byte[] convertRegionName(@NotNull String regionName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)regionName, (String)"regionName");
        try {
            String string = new JSONObject().put(KEY_REGION_NAME, (Object)regionName).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject().put(KEY_REG\u2026E, regionName).toString()");
            object = string;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = object;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"regionName: conversion from String to ByteArray failed", (Throwable)e);
            object = null;
        }
        return object;
    }

    @Nullable
    public final String convertRegionName(@Nullable byte[] regionName) {
        String string;
        try {
            String string2;
            if (regionName != null) {
                boolean bl = false;
                string2 = new JSONObject(new String(regionName, Charsets.UTF_8)).getString(KEY_REGION_NAME);
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"regionName: conversion from ByteArray to String failed", (Throwable)e);
            string = null;
        }
        return string;
    }

    public final int getCompletionPercentage(long completedResourceCount, long requiredResourceCount) {
        return (int)(requiredResourceCount > 0L ? 100.0 * (double)completedResourceCount / (double)requiredResourceCount : 0.0);
    }

    @Nullable
    public final Long getRegionIdFromIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        Object object = bundle != null ? bundle.get("extra.REGION_ID_FOR_ACTIVITY") : null;
        if (!(object instanceof Long)) {
            object = null;
        }
        return (Long)object;
    }

    private OfflineUtils() {
    }

    static {
        OfflineUtils offlineUtils;
        INSTANCE = offlineUtils = new OfflineUtils();
    }
}

