/*
 * Decompiled with CFR 0.152.
 */
package dev.micheleferretti.mapboxpluginoffline.utils;

import android.os.Bundle;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.offline.OfflineRegion;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineRegionStatus;
import dev.micheleferretti.mapboxpluginoffline.utils.OfflineUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005*\u00020\u0003\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u00a8\u0006\u000f"}, d2={"convertToString", "", "Lcom/mapbox/mapboxsdk/offline/OfflineRegion;", "Lcom/mapbox/mapboxsdk/offline/OfflineRegionDefinition;", "getCameraPosition", "Lcom/mapbox/mapboxsdk/camera/CameraPosition;", "kotlin.jvm.PlatformType", "getCompletionPercentage", "", "Lcom/mapbox/mapboxsdk/offline/OfflineRegionStatus;", "getName", "requireLong", "", "Landroid/os/Bundle;", "key", "mapboxpluginoffline-2.2.0_release"})
public final class ExtensionsKt {
    public static final long requireLong(@NotNull Bundle $this$requireLong, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$requireLong, (String)"$this$requireLong");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = $this$requireLong.get(key);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
        }
        return (Long)object;
    }

    @NotNull
    public static final String convertToString(@NotNull OfflineRegion $this$convertToString) {
        Intrinsics.checkNotNullParameter((Object)$this$convertToString, (String)"$this$convertToString");
        StringBuilder stringBuilder = new StringBuilder().append("OfflineRegion(").append("id=").append($this$convertToString.getID()).append(", ").append("name=").append(ExtensionsKt.getName($this$convertToString)).append(", ").append("definition=");
        OfflineRegionDefinition offlineRegionDefinition = $this$convertToString.getDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)offlineRegionDefinition, (String)"definition");
        return stringBuilder.append(ExtensionsKt.convertToString(offlineRegionDefinition)).append(", ").append("isDeliveringInactiveMessages=").append($this$convertToString.isDeliveringInactiveMessages()).append(")").toString();
    }

    @Nullable
    public static final String getName(@NotNull OfflineRegion $this$getName) {
        Intrinsics.checkNotNullParameter((Object)$this$getName, (String)"$this$getName");
        return OfflineUtils.INSTANCE.convertRegionName($this$getName.getMetadata());
    }

    @NotNull
    public static final String convertToString(@NotNull OfflineRegionDefinition $this$convertToString) {
        Intrinsics.checkNotNullParameter((Object)$this$convertToString, (String)"$this$convertToString");
        return "OfflineRegionDefinition(" + "styleURL=" + $this$convertToString.getStyleURL() + ", " + "type=" + $this$convertToString.getType() + ", " + "includeIdeographs=" + $this$convertToString.getIncludeIdeographs() + ", " + "pixelRatio=" + $this$convertToString.getPixelRatio() + ", " + "minZoom=" + $this$convertToString.getMinZoom() + ", " + "maxZoom=" + $this$convertToString.getMaxZoom() + ", " + "bounds=" + $this$convertToString.getBounds() + ")";
    }

    public static final CameraPosition getCameraPosition(@NotNull OfflineRegionDefinition $this$getCameraPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraPosition, (String)"$this$getCameraPosition");
        CameraPosition.Builder builder = new CameraPosition.Builder();
        LatLngBounds latLngBounds = $this$getCameraPosition.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)latLngBounds, (String)"bounds");
        return builder.target(latLngBounds.getCenter()).zoom($this$getCameraPosition.getMinZoom()).build();
    }

    public static final int getCompletionPercentage(@NotNull OfflineRegionStatus $this$getCompletionPercentage) {
        Intrinsics.checkNotNullParameter((Object)$this$getCompletionPercentage, (String)"$this$getCompletionPercentage");
        return OfflineUtils.INSTANCE.getCompletionPercentage($this$getCompletionPercentage.getCompletedResourceCount(), $this$getCompletionPercentage.getRequiredResourceCount());
    }
}

