/*
 * Decompiled with CFR 0.152.
 */
package dev.micheleferretti.mapboxpluginoffline.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import dev.micheleferretti.mapboxpluginoffline.model.NotificationOptions;
import dev.micheleferretti.mapboxpluginoffline.utils.ExtensionsKt;
import dev.micheleferretti.mapboxpluginoffline.utils.OfflineUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;", "Landroid/os/Parcelable;", "definition", "Lcom/mapbox/mapboxsdk/offline/OfflineRegionDefinition;", "notificationOptions", "Ldev/micheleferretti/mapboxpluginoffline/model/NotificationOptions;", "regionName", "", "(Lcom/mapbox/mapboxsdk/offline/OfflineRegionDefinition;Ldev/micheleferretti/mapboxpluginoffline/model/NotificationOptions;Ljava/lang/String;)V", "metadata", "", "(Lcom/mapbox/mapboxsdk/offline/OfflineRegionDefinition;Ldev/micheleferretti/mapboxpluginoffline/model/NotificationOptions;[B)V", "getDefinition", "()Lcom/mapbox/mapboxsdk/offline/OfflineRegionDefinition;", "getMetadata", "()[B", "getNotificationOptions", "()Ldev/micheleferretti/mapboxpluginoffline/model/NotificationOptions;", "describeContents", "", "getRegionName", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "mapboxpluginoffline-2.0.3_release"})
@Parcelize
public final class OfflineDownloadOptions
implements Parcelable {
    @NotNull
    private final OfflineRegionDefinition definition;
    @NotNull
    private final NotificationOptions notificationOptions;
    @Nullable
    private final byte[] metadata;
    public static final Parcelable.Creator CREATOR = new Creator();

    @Nullable
    public final String getRegionName() {
        return OfflineUtils.INSTANCE.convertRegionName(this.metadata);
    }

    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("OfflineDownloadOptions(").append("definition=").append(ExtensionsKt.convertToString(this.definition)).append(", ").append("notificationOptions=").append(this.notificationOptions).append(", ").append("metadata=");
        if (this.metadata != null) {
            byte[] byArray = this.metadata;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            String string2 = Arrays.toString(byArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.util.Arrays.toString(this)");
            String string3 = string2;
            stringBuilder = stringBuilder2;
            string = string3;
        } else {
            string = null;
        }
        return stringBuilder.append(string).append(")").toString();
    }

    @NotNull
    public final OfflineRegionDefinition getDefinition() {
        return this.definition;
    }

    @NotNull
    public final NotificationOptions getNotificationOptions() {
        return this.notificationOptions;
    }

    @Nullable
    public final byte[] getMetadata() {
        return this.metadata;
    }

    public OfflineDownloadOptions(@NotNull OfflineRegionDefinition definition, @NotNull NotificationOptions notificationOptions, @Nullable byte[] metadata) {
        Intrinsics.checkParameterIsNotNull((Object)definition, (String)"definition");
        Intrinsics.checkParameterIsNotNull((Object)notificationOptions, (String)"notificationOptions");
        this.definition = definition;
        this.notificationOptions = notificationOptions;
        this.metadata = metadata;
    }

    public OfflineDownloadOptions(@NotNull OfflineRegionDefinition definition, @NotNull NotificationOptions notificationOptions, @NotNull String regionName) {
        Intrinsics.checkParameterIsNotNull((Object)definition, (String)"definition");
        Intrinsics.checkParameterIsNotNull((Object)notificationOptions, (String)"notificationOptions");
        Intrinsics.checkParameterIsNotNull((Object)regionName, (String)"regionName");
        this(definition, notificationOptions, OfflineUtils.INSTANCE.convertRegionName(regionName));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        parcel.writeParcelable((Parcelable)this.definition, flags);
        this.notificationOptions.writeToParcel(parcel, 0);
        parcel.writeByteArray(this.metadata);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator {
        @NotNull
        public final Object[] newArray(int size) {
            return new OfflineDownloadOptions[size];
        }

        @NotNull
        public final Object createFromParcel(@NotNull Parcel in) {
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            return new OfflineDownloadOptions((OfflineRegionDefinition)in.readParcelable(OfflineDownloadOptions.class.getClassLoader()), (NotificationOptions)NotificationOptions.CREATOR.createFromParcel(in), in.createByteArray());
        }
    }
}

