/*
 * Decompiled with CFR 0.152.
 */
package dev.micheleferretti.mapboxpluginoffline.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.offline.OfflineRegionStatus;
import dev.micheleferretti.mapboxpluginoffline.model.OfflineDownloadOptions;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u000bJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0019\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0012H\u00d6\u0001R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownload;", "Landroid/os/Parcelable;", "regionId", "", "options", "Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;", "(JLdev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;)V", "completedResourceCount", "requiredResourceCount", "completedResourceSize", "isActive", "", "(JLdev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;JJJZ)V", "getOptions", "()Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;", "getRegionId", "()J", "describeContents", "", "getCompletedResourceCount", "getCompletedResourceSize", "getPercentage", "getRequiredResourceCount", "isComplete", "setStatus", "", "status", "Lcom/mapbox/mapboxsdk/offline/OfflineRegionStatus;", "setStatus$mapboxpluginoffline_2_0_3_release", "toString", "", "writeToParcel", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "mapboxpluginoffline-2.0.3_release"})
@Parcelize
public final class OfflineDownload
implements Parcelable {
    private final long regionId;
    @NotNull
    private final OfflineDownloadOptions options;
    private long completedResourceCount;
    private long requiredResourceCount;
    private long completedResourceSize;
    private boolean isActive;
    public static final Companion Companion = new Companion(null);
    public static final Parcelable.Creator CREATOR = new Creator();

    public final long getCompletedResourceCount() {
        return this.completedResourceCount;
    }

    public final long getRequiredResourceCount() {
        return this.requiredResourceCount;
    }

    public final long getCompletedResourceSize() {
        return this.completedResourceSize;
    }

    public final int getPercentage() {
        return Companion.getPercentage(this.completedResourceCount, this.requiredResourceCount);
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final boolean isComplete() {
        return this.completedResourceCount >= this.requiredResourceCount;
    }

    public final void setStatus$mapboxpluginoffline_2_0_3_release(@NotNull OfflineRegionStatus status) {
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        this.completedResourceCount = status.getCompletedResourceCount();
        this.requiredResourceCount = status.getRequiredResourceCount();
        this.completedResourceSize = status.getCompletedResourceSize();
        this.isActive = status.getDownloadState() == 1;
    }

    @NotNull
    public String toString() {
        return "OfflineDownload(" + "regionId=" + this.regionId + ", " + "options=" + this.options + ", " + "completedResourceCount=" + this.completedResourceCount + ", " + "requiredResourceCount=" + this.requiredResourceCount + ", " + "completedResourceSize=" + this.completedResourceSize + ", " + "isActive=" + this.isActive + ")";
    }

    public final long getRegionId() {
        return this.regionId;
    }

    @NotNull
    public final OfflineDownloadOptions getOptions() {
        return this.options;
    }

    public OfflineDownload(long regionId, @NotNull OfflineDownloadOptions options, long completedResourceCount, long requiredResourceCount, long completedResourceSize, boolean isActive) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.regionId = regionId;
        this.options = options;
        this.completedResourceCount = completedResourceCount;
        this.requiredResourceCount = requiredResourceCount;
        this.completedResourceSize = completedResourceSize;
        this.isActive = isActive;
    }

    public OfflineDownload(long regionId, @NotNull OfflineDownloadOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this(regionId, options, 0L, 0L, 0L, false);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        parcel.writeLong(this.regionId);
        this.options.writeToParcel(parcel, 0);
        parcel.writeLong(this.completedResourceCount);
        parcel.writeLong(this.requiredResourceCount);
        parcel.writeLong(this.completedResourceSize);
        parcel.writeInt(this.isActive ? 1 : 0);
    }

    @JvmStatic
    public static final int getPercentage(long completedResourceCount, long requiredResourceCount) {
        return Companion.getPercentage(completedResourceCount, requiredResourceCount);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator {
        @NotNull
        public final Object[] newArray(int size) {
            return new OfflineDownload[size];
        }

        @NotNull
        public final Object createFromParcel(@NotNull Parcel in) {
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            return new OfflineDownload(in.readLong(), (OfflineDownloadOptions)OfflineDownloadOptions.CREATOR.createFromParcel(in), in.readLong(), in.readLong(), in.readLong(), in.readInt() != 0);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownload$Companion;", "", "()V", "getPercentage", "", "completedResourceCount", "", "requiredResourceCount", "mapboxpluginoffline-2.0.3_release"})
    public static final class Companion {
        @JvmStatic
        public final int getPercentage(long completedResourceCount, long requiredResourceCount) {
            return (int)(requiredResourceCount > 0L ? 100.0 * (double)completedResourceCount / (double)requiredResourceCount : 0.0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

