/*
 * Decompiled with CFR 0.152.
 */
package dev.micheleferretti.mapboxpluginoffline.model;

import android.os.Bundle;
import com.mapbox.mapboxsdk.offline.OfflineRegionStatus;
import dev.micheleferretti.mapboxpluginoffline.model.OfflineDownloadOptions;
import dev.micheleferretti.mapboxpluginoffline.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u000bJ\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownload;", "", "regionId", "", "options", "Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;", "(JLdev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;)V", "completedResourceCount", "requiredResourceCount", "completedResourceSize", "isActive", "", "(JLdev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;JJJZ)V", "getOptions", "()Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownloadOptions;", "getRegionId", "()J", "getCompletedResourceCount", "getCompletedResourceSize", "getPercentage", "", "getRequiredResourceCount", "isComplete", "setStatus", "", "status", "Lcom/mapbox/mapboxsdk/offline/OfflineRegionStatus;", "setStatus$mapboxpluginoffline_1_1_8_release", "toBundle", "Landroid/os/Bundle;", "toString", "", "Companion", "mapboxpluginoffline-1.1.8_release"})
public final class OfflineDownload {
    private final long regionId;
    @NotNull
    private final OfflineDownloadOptions options;
    private long completedResourceCount;
    private long requiredResourceCount;
    private long completedResourceSize;
    private boolean isActive;
    private static final String EXTRA_REGION_ID = "extra.REGION_ID";
    private static final String EXTRA_OPTIONS = "extra.OPTIONS";
    private static final String EXTRA_COMPLETED_RESOURCE_COUNT = "extra.COMPLETED_RESOURCE_COUNT";
    private static final String EXTRA_REQUIRED_RESOURCE_COUNT = "extra.REQUIRED_RESOURCE_COUNT";
    private static final String EXTRA_COMPLETED_RESOURCE_SIZE = "extra.COMPLETED_RESOURCE_SIZE";
    private static final String EXTRA_IS_ACTIVE = "extra.IS_ACTIVE";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Bundle toBundle() {
        Bundle bundle = new Bundle();
        boolean bl = false;
        boolean bl2 = false;
        Bundle $this$apply = bundle;
        boolean bl3 = false;
        $this$apply.putLong(EXTRA_REGION_ID, this.regionId);
        $this$apply.putBundle(EXTRA_OPTIONS, this.options.toBundle());
        $this$apply.putLong(EXTRA_COMPLETED_RESOURCE_COUNT, this.completedResourceCount);
        $this$apply.putLong(EXTRA_REQUIRED_RESOURCE_COUNT, this.requiredResourceCount);
        $this$apply.putLong(EXTRA_COMPLETED_RESOURCE_SIZE, this.completedResourceSize);
        $this$apply.putBoolean(EXTRA_IS_ACTIVE, this.isActive);
        return bundle;
    }

    public final long getCompletedResourceCount() {
        return this.completedResourceCount;
    }

    public final long getRequiredResourceCount() {
        return this.requiredResourceCount;
    }

    public final long getCompletedResourceSize() {
        return this.completedResourceSize;
    }

    public final int getPercentage() {
        return Companion.getPercentage(this.completedResourceCount, this.requiredResourceCount);
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final boolean isComplete() {
        return this.completedResourceCount >= this.requiredResourceCount;
    }

    public final void setStatus$mapboxpluginoffline_1_1_8_release(@NotNull OfflineRegionStatus status) {
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        this.completedResourceCount = status.getCompletedResourceCount();
        this.requiredResourceCount = status.getRequiredResourceCount();
        this.completedResourceSize = status.getCompletedResourceSize();
        this.isActive = status.getDownloadState() == 1;
    }

    @NotNull
    public String toString() {
        return "OfflineDownload(" + "regionId=" + this.regionId + ", " + "options=" + this.options + ", " + "completedResourceCount=" + this.completedResourceCount + ", " + "requiredResourceCount=" + this.requiredResourceCount + ", " + "completedResourceSize=" + this.completedResourceSize + ", " + "isActive=" + this.isActive + ")";
    }

    public final long getRegionId() {
        return this.regionId;
    }

    @NotNull
    public final OfflineDownloadOptions getOptions() {
        return this.options;
    }

    public OfflineDownload(long regionId, @NotNull OfflineDownloadOptions options, long completedResourceCount, long requiredResourceCount, long completedResourceSize, boolean isActive) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.regionId = regionId;
        this.options = options;
        this.completedResourceCount = completedResourceCount;
        this.requiredResourceCount = requiredResourceCount;
        this.completedResourceSize = completedResourceSize;
        this.isActive = isActive;
    }

    public OfflineDownload(long regionId, @NotNull OfflineDownloadOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this(regionId, options, 0L, 0L, 0L, false);
    }

    @JvmStatic
    @NotNull
    public static final OfflineDownload fromBundle(@NotNull Bundle bundle) {
        return Companion.fromBundle(bundle);
    }

    @JvmStatic
    public static final int getPercentage(long completedResourceCount, long requiredResourceCount) {
        return Companion.getPercentage(completedResourceCount, requiredResourceCount);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownload$Companion;", "", "()V", "EXTRA_COMPLETED_RESOURCE_COUNT", "", "EXTRA_COMPLETED_RESOURCE_SIZE", "EXTRA_IS_ACTIVE", "EXTRA_OPTIONS", "EXTRA_REGION_ID", "EXTRA_REQUIRED_RESOURCE_COUNT", "fromBundle", "Ldev/micheleferretti/mapboxpluginoffline/model/OfflineDownload;", "bundle", "Landroid/os/Bundle;", "getPercentage", "", "completedResourceCount", "", "requiredResourceCount", "mapboxpluginoffline-1.1.8_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final OfflineDownload fromBundle(@NotNull Bundle bundle) {
            Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
            Bundle bundle2 = bundle.getBundle(OfflineDownload.EXTRA_OPTIONS);
            OfflineDownloadOptions.Companion companion = OfflineDownloadOptions.Companion;
            long l = ExtensionsKt.requireLong(bundle, OfflineDownload.EXTRA_REGION_ID);
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (bundle2 == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            Bundle bundle3 = bundle2;
            boolean bl5 = ExtensionsKt.requireBoolean(bundle, OfflineDownload.EXTRA_IS_ACTIVE);
            long l2 = ExtensionsKt.requireLong(bundle, OfflineDownload.EXTRA_COMPLETED_RESOURCE_SIZE);
            long l3 = ExtensionsKt.requireLong(bundle, OfflineDownload.EXTRA_REQUIRED_RESOURCE_COUNT);
            long l4 = ExtensionsKt.requireLong(bundle, OfflineDownload.EXTRA_COMPLETED_RESOURCE_COUNT);
            OfflineDownloadOptions offlineDownloadOptions = companion.fromBundle(bundle3);
            long l5 = l;
            return new OfflineDownload(l5, offlineDownloadOptions, l4, l3, l2, bl5);
        }

        @JvmStatic
        public final int getPercentage(long completedResourceCount, long requiredResourceCount) {
            return (int)(requiredResourceCount > 0L ? 100.0 * (double)completedResourceCount / (double)requiredResourceCount : 0.0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

